/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.edqs;

import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.ObjectType;
import org.thingsboard.server.common.data.edqs.DataPoint;
import org.thingsboard.server.common.data.edqs.EdqsObject;
import org.thingsboard.server.common.data.edqs.EdqsObjectKey;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;

public class LatestTsKv
implements EdqsObject {
    private EntityId entityId;
    private String key;
    private Long version;
    private DataPoint dataPoint;
    private Long ts;
    private KvEntry value;

    public LatestTsKv(EntityId entityId, TsKvEntry tsKvEntry, Long version) {
        this.entityId = entityId;
        this.key = tsKvEntry.getKey();
        this.ts = tsKvEntry.getTs();
        this.version = version != null ? version : 0L;
        this.value = tsKvEntry;
    }

    public LatestTsKv(EntityId entityId, String key, Long version) {
        this.entityId = entityId;
        this.key = key;
        this.version = version != null ? version : 0L;
    }

    @Override
    public String stringKey() {
        return "l_" + String.valueOf(this.entityId) + "_" + this.key;
    }

    @Override
    public Long version() {
        return this.version;
    }

    @Override
    public ObjectType type() {
        return ObjectType.LATEST_TS_KV;
    }

    @Generated
    public static LatestTsKvBuilder builder() {
        return new LatestTsKvBuilder();
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public DataPoint getDataPoint() {
        return this.dataPoint;
    }

    @Generated
    public Long getTs() {
        return this.ts;
    }

    @Generated
    public KvEntry getValue() {
        return this.value;
    }

    @Generated
    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public void setDataPoint(DataPoint dataPoint) {
        this.dataPoint = dataPoint;
    }

    @Generated
    public void setTs(Long ts) {
        this.ts = ts;
    }

    @Generated
    public void setValue(KvEntry value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LatestTsKv)) {
            return false;
        }
        LatestTsKv other = (LatestTsKv)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Long this$ts = this.getTs();
        Long other$ts = other.getTs();
        if (this$ts == null ? other$ts != null : !((Object)this$ts).equals(other$ts)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        DataPoint this$dataPoint = this.getDataPoint();
        DataPoint other$dataPoint = other.getDataPoint();
        if (this$dataPoint == null ? other$dataPoint != null : !this$dataPoint.equals(other$dataPoint)) {
            return false;
        }
        KvEntry this$value = this.getValue();
        KvEntry other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LatestTsKv;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Long $ts = this.getTs();
        result = result * 59 + ($ts == null ? 43 : ((Object)$ts).hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        DataPoint $dataPoint = this.getDataPoint();
        result = result * 59 + ($dataPoint == null ? 43 : $dataPoint.hashCode());
        KvEntry $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LatestTsKv(entityId=" + String.valueOf(this.getEntityId()) + ", key=" + this.getKey() + ", version=" + this.getVersion() + ", dataPoint=" + String.valueOf(this.getDataPoint()) + ", ts=" + this.getTs() + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    @ConstructorProperties(value={"entityId", "key", "version", "dataPoint", "ts", "value"})
    @Generated
    public LatestTsKv(EntityId entityId, String key, Long version, DataPoint dataPoint, Long ts, KvEntry value) {
        this.entityId = entityId;
        this.key = key;
        this.version = version;
        this.dataPoint = dataPoint;
        this.ts = ts;
        this.value = value;
    }

    @Generated
    public LatestTsKv() {
    }

    @Generated
    public static class LatestTsKvBuilder {
        @Generated
        private EntityId entityId;
        @Generated
        private String key;
        @Generated
        private Long version;
        @Generated
        private DataPoint dataPoint;
        @Generated
        private Long ts;
        @Generated
        private KvEntry value;

        @Generated
        LatestTsKvBuilder() {
        }

        @Generated
        public LatestTsKvBuilder entityId(EntityId entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public LatestTsKvBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public LatestTsKvBuilder version(Long version) {
            this.version = version;
            return this;
        }

        @Generated
        public LatestTsKvBuilder dataPoint(DataPoint dataPoint) {
            this.dataPoint = dataPoint;
            return this;
        }

        @Generated
        public LatestTsKvBuilder ts(Long ts) {
            this.ts = ts;
            return this;
        }

        @Generated
        public LatestTsKvBuilder value(KvEntry value) {
            this.value = value;
            return this;
        }

        @Generated
        public LatestTsKv build() {
            return new LatestTsKv(this.entityId, this.key, this.version, this.dataPoint, this.ts, this.value);
        }

        @Generated
        public String toString() {
            return "LatestTsKv.LatestTsKvBuilder(entityId=" + String.valueOf(this.entityId) + ", key=" + this.key + ", version=" + this.version + ", dataPoint=" + String.valueOf(this.dataPoint) + ", ts=" + this.ts + ", value=" + String.valueOf(this.value) + ")";
        }
    }

    public record Key(UUID entityId, int key) implements EdqsObjectKey
    {
    }
}

