/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.edqs;

import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.ObjectType;
import org.thingsboard.server.common.data.edqs.DataPoint;
import org.thingsboard.server.common.data.edqs.EdqsObject;
import org.thingsboard.server.common.data.edqs.EdqsObjectKey;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;

public class AttributeKv
implements EdqsObject {
    private EntityId entityId;
    private AttributeScope scope;
    private String key;
    private Long version;
    private DataPoint dataPoint;
    private Long lastUpdateTs;
    private KvEntry value;

    public AttributeKv(EntityId entityId, AttributeScope scope, AttributeKvEntry attributeKvEntry, long version) {
        this.entityId = entityId;
        this.scope = scope;
        this.key = attributeKvEntry.getKey();
        this.version = version;
        this.lastUpdateTs = attributeKvEntry.getLastUpdateTs();
        this.value = attributeKvEntry;
    }

    public AttributeKv(EntityId entityId, AttributeScope scope, String key, long version) {
        this.entityId = entityId;
        this.scope = scope;
        this.key = key;
        this.version = version;
    }

    @Override
    public String stringKey() {
        return "a_" + String.valueOf(this.entityId) + "_" + String.valueOf((Object)this.scope) + "_" + this.key;
    }

    @Override
    public Long version() {
        return this.version;
    }

    @Override
    public ObjectType type() {
        return ObjectType.ATTRIBUTE_KV;
    }

    @Generated
    public static AttributeKvBuilder builder() {
        return new AttributeKvBuilder();
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public AttributeScope getScope() {
        return this.scope;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public DataPoint getDataPoint() {
        return this.dataPoint;
    }

    @Generated
    public Long getLastUpdateTs() {
        return this.lastUpdateTs;
    }

    @Generated
    public KvEntry getValue() {
        return this.value;
    }

    @Generated
    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setScope(AttributeScope scope) {
        this.scope = scope;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public void setDataPoint(DataPoint dataPoint) {
        this.dataPoint = dataPoint;
    }

    @Generated
    public void setLastUpdateTs(Long lastUpdateTs) {
        this.lastUpdateTs = lastUpdateTs;
    }

    @Generated
    public void setValue(KvEntry value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeKv)) {
            return false;
        }
        AttributeKv other = (AttributeKv)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Long this$lastUpdateTs = this.getLastUpdateTs();
        Long other$lastUpdateTs = other.getLastUpdateTs();
        if (this$lastUpdateTs == null ? other$lastUpdateTs != null : !((Object)this$lastUpdateTs).equals(other$lastUpdateTs)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        AttributeScope this$scope = this.getScope();
        AttributeScope other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        DataPoint this$dataPoint = this.getDataPoint();
        DataPoint other$dataPoint = other.getDataPoint();
        if (this$dataPoint == null ? other$dataPoint != null : !this$dataPoint.equals(other$dataPoint)) {
            return false;
        }
        KvEntry this$value = this.getValue();
        KvEntry other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AttributeKv;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Long $lastUpdateTs = this.getLastUpdateTs();
        result = result * 59 + ($lastUpdateTs == null ? 43 : ((Object)$lastUpdateTs).hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        AttributeScope $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        DataPoint $dataPoint = this.getDataPoint();
        result = result * 59 + ($dataPoint == null ? 43 : $dataPoint.hashCode());
        KvEntry $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AttributeKv(entityId=" + String.valueOf(this.getEntityId()) + ", scope=" + String.valueOf((Object)this.getScope()) + ", key=" + this.getKey() + ", version=" + this.getVersion() + ", dataPoint=" + String.valueOf(this.getDataPoint()) + ", lastUpdateTs=" + this.getLastUpdateTs() + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    @ConstructorProperties(value={"entityId", "scope", "key", "version", "dataPoint", "lastUpdateTs", "value"})
    @Generated
    public AttributeKv(EntityId entityId, AttributeScope scope, String key, Long version, DataPoint dataPoint, Long lastUpdateTs, KvEntry value) {
        this.entityId = entityId;
        this.scope = scope;
        this.key = key;
        this.version = version;
        this.dataPoint = dataPoint;
        this.lastUpdateTs = lastUpdateTs;
        this.value = value;
    }

    @Generated
    public AttributeKv() {
    }

    @Generated
    public static class AttributeKvBuilder {
        @Generated
        private EntityId entityId;
        @Generated
        private AttributeScope scope;
        @Generated
        private String key;
        @Generated
        private Long version;
        @Generated
        private DataPoint dataPoint;
        @Generated
        private Long lastUpdateTs;
        @Generated
        private KvEntry value;

        @Generated
        AttributeKvBuilder() {
        }

        @Generated
        public AttributeKvBuilder entityId(EntityId entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public AttributeKvBuilder scope(AttributeScope scope) {
            this.scope = scope;
            return this;
        }

        @Generated
        public AttributeKvBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public AttributeKvBuilder version(Long version) {
            this.version = version;
            return this;
        }

        @Generated
        public AttributeKvBuilder dataPoint(DataPoint dataPoint) {
            this.dataPoint = dataPoint;
            return this;
        }

        @Generated
        public AttributeKvBuilder lastUpdateTs(Long lastUpdateTs) {
            this.lastUpdateTs = lastUpdateTs;
            return this;
        }

        @Generated
        public AttributeKvBuilder value(KvEntry value) {
            this.value = value;
            return this;
        }

        @Generated
        public AttributeKv build() {
            return new AttributeKv(this.entityId, this.scope, this.key, this.version, this.dataPoint, this.lastUpdateTs, this.value);
        }

        @Generated
        public String toString() {
            return "AttributeKv.AttributeKvBuilder(entityId=" + String.valueOf(this.entityId) + ", scope=" + String.valueOf((Object)this.scope) + ", key=" + this.key + ", version=" + this.version + ", dataPoint=" + String.valueOf(this.dataPoint) + ", lastUpdateTs=" + this.lastUpdateTs + ", value=" + String.valueOf(this.value) + ")";
        }
    }

    public record Key(UUID entityId, AttributeScope scope, int key) implements EdqsObjectKey
    {
    }
}

