/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.DomainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;

public class Domain
extends BaseData<DomainId>
implements HasTenantId,
HasName {
    @Schema(description="JSON object with Tenant Id")
    private TenantId tenantId;
    @Schema(description="Domain name. Cannot be empty", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotBlank
    @Length(fieldName="name")
    private String name;
    @Schema(description="Whether OAuth2 settings are enabled or not")
    private boolean oauth2Enabled;
    @Schema(description="Whether OAuth2 settings are enabled on Edge or not")
    private boolean propagateToEdge;

    public Domain() {
    }

    public Domain(DomainId id) {
        super(id);
    }

    public Domain(Domain domain) {
        super(domain);
        this.tenantId = domain.tenantId;
        this.name = domain.name;
        this.oauth2Enabled = domain.oauth2Enabled;
        this.propagateToEdge = domain.propagateToEdge;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Domain)) {
            return false;
        }
        Domain other = (Domain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isOauth2Enabled() != other.isOauth2Enabled()) {
            return false;
        }
        if (this.isPropagateToEdge() != other.isPropagateToEdge()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Domain;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isOauth2Enabled() ? 79 : 97);
        result = result * 59 + (this.isPropagateToEdge() ? 79 : 97);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isOauth2Enabled() {
        return this.oauth2Enabled;
    }

    @Generated
    public boolean isPropagateToEdge() {
        return this.propagateToEdge;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setOauth2Enabled(boolean oauth2Enabled) {
        this.oauth2Enabled = oauth2Enabled;
    }

    @Generated
    public void setPropagateToEdge(boolean propagateToEdge) {
        this.propagateToEdge = propagateToEdge;
    }

    @Override
    @Generated
    public String toString() {
        return "Domain(tenantId=" + String.valueOf(this.getTenantId()) + ", name=" + this.getName() + ", oauth2Enabled=" + this.isOauth2Enabled() + ", propagateToEdge=" + this.isPropagateToEdge() + ")";
    }
}

