/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.debug;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

public class DebugSettings {
    private static DebugSettings DEBUG_OFF = new DebugSettings(false, 0L);
    private static DebugSettings DEBUG_FAILURES = new DebugSettings(true, 0L);
    @Schema(description="Debug failures. ", example="false")
    private boolean failuresEnabled;
    @Schema(description="Debug All. Used as a trigger for updating debugAllUntil.", example="false")
    private boolean allEnabled;
    @Schema(description="Timestamp of the end time for the processing debug events.")
    private long allEnabledUntil;

    public DebugSettings(boolean failuresEnabled, long allEnabledUntil) {
        this.failuresEnabled = failuresEnabled;
        this.allEnabled = false;
        this.allEnabledUntil = allEnabledUntil;
    }

    public static DebugSettings off() {
        return DEBUG_OFF;
    }

    public static DebugSettings failures() {
        return DEBUG_FAILURES;
    }

    public static DebugSettings until(long ts) {
        return new DebugSettings(false, ts);
    }

    public static DebugSettings failuresOrUntil(long ts) {
        return new DebugSettings(true, ts);
    }

    public static DebugSettings all() {
        DebugSettings ds = new DebugSettings();
        ds.setAllEnabled(true);
        return ds;
    }

    public DebugSettings copy(long maxDebugAllUntil) {
        return new DebugSettings(this.failuresEnabled, this.allEnabled ? maxDebugAllUntil : Math.min(this.allEnabledUntil, maxDebugAllUntil));
    }

    @Generated
    public boolean isFailuresEnabled() {
        return this.failuresEnabled;
    }

    @Generated
    public boolean isAllEnabled() {
        return this.allEnabled;
    }

    @Generated
    public long getAllEnabledUntil() {
        return this.allEnabledUntil;
    }

    @Generated
    public void setFailuresEnabled(boolean failuresEnabled) {
        this.failuresEnabled = failuresEnabled;
    }

    @Generated
    public void setAllEnabled(boolean allEnabled) {
        this.allEnabled = allEnabled;
    }

    @Generated
    public void setAllEnabledUntil(long allEnabledUntil) {
        this.allEnabledUntil = allEnabledUntil;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebugSettings)) {
            return false;
        }
        DebugSettings other = (DebugSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFailuresEnabled() != other.isFailuresEnabled()) {
            return false;
        }
        if (this.isAllEnabled() != other.isAllEnabled()) {
            return false;
        }
        return this.getAllEnabledUntil() == other.getAllEnabledUntil();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebugSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFailuresEnabled() ? 79 : 97);
        result = result * 59 + (this.isAllEnabled() ? 79 : 97);
        long $allEnabledUntil = this.getAllEnabledUntil();
        result = result * 59 + (int)($allEnabledUntil >>> 32 ^ $allEnabledUntil);
        return result;
    }

    @Generated
    public String toString() {
        return "DebugSettings(failuresEnabled=" + this.isFailuresEnabled() + ", allEnabled=" + this.isAllEnabled() + ", allEnabledUntil=" + this.getAllEnabledUntil() + ")";
    }

    @Generated
    public DebugSettings() {
    }
}

