/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.cf.configuration;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.server.common.data.cf.CalculatedFieldLink;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;

public abstract class BaseCalculatedFieldConfiguration
implements CalculatedFieldConfiguration {
    protected Map<String, Argument> arguments;
    protected String expression;
    protected Output output;

    @Override
    public List<EntityId> getReferencedEntities() {
        return this.arguments.values().stream().map(Argument::getRefEntityId).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<CalculatedFieldLink> buildCalculatedFieldLinks(TenantId tenantId, EntityId cfEntityId, CalculatedFieldId calculatedFieldId) {
        return this.getReferencedEntities().stream().filter(referencedEntity -> !referencedEntity.equals(cfEntityId)).map(referencedEntityId -> this.buildCalculatedFieldLink(tenantId, (EntityId)referencedEntityId, calculatedFieldId)).collect(Collectors.toList());
    }

    @Override
    public CalculatedFieldLink buildCalculatedFieldLink(TenantId tenantId, EntityId referencedEntityId, CalculatedFieldId calculatedFieldId) {
        CalculatedFieldLink link = new CalculatedFieldLink();
        link.setTenantId(tenantId);
        link.setEntityId(referencedEntityId);
        link.setCalculatedFieldId(calculatedFieldId);
        return link;
    }

    @Generated
    public BaseCalculatedFieldConfiguration() {
    }

    @Override
    @Generated
    public Map<String, Argument> getArguments() {
        return this.arguments;
    }

    @Override
    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Override
    @Generated
    public Output getOutput() {
        return this.output;
    }

    @Generated
    public void setArguments(Map<String, Argument> arguments) {
        this.arguments = arguments;
    }

    @Override
    @Generated
    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Generated
    public void setOutput(Output output) {
        this.output = output;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseCalculatedFieldConfiguration)) {
            return false;
        }
        BaseCalculatedFieldConfiguration other = (BaseCalculatedFieldConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Argument> this$arguments = this.getArguments();
        Map<String, Argument> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        Output this$output = this.getOutput();
        Output other$output = other.getOutput();
        return !(this$output == null ? other$output != null : !((Object)this$output).equals(other$output));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseCalculatedFieldConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        Output $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BaseCalculatedFieldConfiguration(arguments=" + String.valueOf(this.getArguments()) + ", expression=" + this.getExpression() + ", output=" + String.valueOf(this.getOutput()) + ")";
    }
}

