/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.asset;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasDefaultOption;
import org.thingsboard.server.common.data.HasImage;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasRuleEngineProfile;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class AssetProfile
extends BaseData<AssetProfileId>
implements HasName,
HasTenantId,
HasRuleEngineProfile,
ExportableEntity<AssetProfileId>,
HasImage,
HasDefaultOption,
HasVersion {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetProfile.class);
    private static final long serialVersionUID = 6998485460273302018L;
    @Schema(description="JSON object with Tenant Id that owns the profile.", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="name")
    @Schema(description="Unique Asset Profile Name in scope of Tenant.", example="Building")
    private String name;
    @NoXss
    @Schema(description="Asset Profile description. ")
    private String description;
    @Schema(description="Either URL or Base64 data of the icon. Used in the mobile application to visualize set of asset profiles in the grid view. ")
    private String image;
    private boolean isDefault;
    @Schema(description="Reference to the rule chain. If present, the specified rule chain will be used to process all messages related to asset, including asset updates, telemetry, attribute updates, etc. Otherwise, the root rule chain will be used to process those messages.")
    private RuleChainId defaultRuleChainId;
    @Schema(description="Reference to the dashboard. Used in the mobile application to open the default dashboard when user navigates to asset details.")
    private DashboardId defaultDashboardId;
    @NoXss
    @Schema(description="Rule engine queue name. If present, the specified queue will be used to store all unprocessed messages related to asset, including asset updates, telemetry, attribute updates, etc. Otherwise, the 'Main' queue will be used to store those messages.")
    private String defaultQueueName;
    @Schema(description="Reference to the edge rule chain. If present, the specified edge rule chain will be used on the edge to process all messages related to asset, including asset updates, telemetry, attribute updates, etc. Otherwise, the edge root rule chain will be used to process those messages.")
    private RuleChainId defaultEdgeRuleChainId;
    private AssetProfileId externalId;
    private Long version;

    public AssetProfile() {
    }

    public AssetProfile(AssetProfileId assetProfileId) {
        super(assetProfileId);
    }

    public AssetProfile(AssetProfile assetProfile) {
        super(assetProfile);
        this.tenantId = assetProfile.getTenantId();
        this.name = assetProfile.getName();
        this.description = assetProfile.getDescription();
        this.image = assetProfile.getImage();
        this.isDefault = assetProfile.isDefault();
        this.defaultRuleChainId = assetProfile.getDefaultRuleChainId();
        this.defaultDashboardId = assetProfile.getDefaultDashboardId();
        this.defaultQueueName = assetProfile.getDefaultQueueName();
        this.defaultEdgeRuleChainId = assetProfile.getDefaultEdgeRuleChainId();
        this.externalId = assetProfile.getExternalId();
        this.version = assetProfile.getVersion();
    }

    @Override
    @Schema(description="JSON object with the asset profile Id. Specify this field to update the asset profile. Referencing non-existing asset profile Id will cause error. Omit this field to create new asset profile.")
    public AssetProfileId getId() {
        return (AssetProfileId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the profile creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Schema(description="Used to mark the default profile. Default profile is used when the asset profile is not specified during asset creation.")
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public String getImage() {
        return this.image;
    }

    @Override
    @Generated
    public RuleChainId getDefaultRuleChainId() {
        return this.defaultRuleChainId;
    }

    @Generated
    public DashboardId getDefaultDashboardId() {
        return this.defaultDashboardId;
    }

    @Override
    @Generated
    public String getDefaultQueueName() {
        return this.defaultQueueName;
    }

    @Generated
    public RuleChainId getDefaultEdgeRuleChainId() {
        return this.defaultEdgeRuleChainId;
    }

    @Override
    @Generated
    public AssetProfileId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Generated
    public void setImage(String image) {
        this.image = image;
    }

    @Generated
    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Generated
    public void setDefaultRuleChainId(RuleChainId defaultRuleChainId) {
        this.defaultRuleChainId = defaultRuleChainId;
    }

    @Generated
    public void setDefaultDashboardId(DashboardId defaultDashboardId) {
        this.defaultDashboardId = defaultDashboardId;
    }

    @Generated
    public void setDefaultQueueName(String defaultQueueName) {
        this.defaultQueueName = defaultQueueName;
    }

    @Generated
    public void setDefaultEdgeRuleChainId(RuleChainId defaultEdgeRuleChainId) {
        this.defaultEdgeRuleChainId = defaultEdgeRuleChainId;
    }

    @Override
    @Generated
    public void setExternalId(AssetProfileId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    @Generated
    public String toString() {
        return "AssetProfile(tenantId=" + String.valueOf(this.getTenantId()) + ", name=" + this.getName() + ", description=" + this.getDescription() + ", isDefault=" + this.isDefault() + ", defaultRuleChainId=" + String.valueOf(this.getDefaultRuleChainId()) + ", defaultDashboardId=" + String.valueOf(this.getDefaultDashboardId()) + ", defaultQueueName=" + this.getDefaultQueueName() + ", defaultEdgeRuleChainId=" + String.valueOf(this.getDefaultEdgeRuleChainId()) + ", externalId=" + String.valueOf(this.getExternalId()) + ", version=" + this.getVersion() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetProfile)) {
            return false;
        }
        AssetProfile other = (AssetProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDefault() != other.isDefault()) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        RuleChainId this$defaultRuleChainId = this.getDefaultRuleChainId();
        RuleChainId other$defaultRuleChainId = other.getDefaultRuleChainId();
        if (this$defaultRuleChainId == null ? other$defaultRuleChainId != null : !((Object)this$defaultRuleChainId).equals(other$defaultRuleChainId)) {
            return false;
        }
        DashboardId this$defaultDashboardId = this.getDefaultDashboardId();
        DashboardId other$defaultDashboardId = other.getDefaultDashboardId();
        if (this$defaultDashboardId == null ? other$defaultDashboardId != null : !((Object)this$defaultDashboardId).equals(other$defaultDashboardId)) {
            return false;
        }
        String this$defaultQueueName = this.getDefaultQueueName();
        String other$defaultQueueName = other.getDefaultQueueName();
        if (this$defaultQueueName == null ? other$defaultQueueName != null : !this$defaultQueueName.equals(other$defaultQueueName)) {
            return false;
        }
        RuleChainId this$defaultEdgeRuleChainId = this.getDefaultEdgeRuleChainId();
        RuleChainId other$defaultEdgeRuleChainId = other.getDefaultEdgeRuleChainId();
        if (this$defaultEdgeRuleChainId == null ? other$defaultEdgeRuleChainId != null : !((Object)this$defaultEdgeRuleChainId).equals(other$defaultEdgeRuleChainId)) {
            return false;
        }
        AssetProfileId this$externalId = this.getExternalId();
        AssetProfileId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetProfile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDefault() ? 79 : 97);
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        RuleChainId $defaultRuleChainId = this.getDefaultRuleChainId();
        result = result * 59 + ($defaultRuleChainId == null ? 43 : ((Object)$defaultRuleChainId).hashCode());
        DashboardId $defaultDashboardId = this.getDefaultDashboardId();
        result = result * 59 + ($defaultDashboardId == null ? 43 : ((Object)$defaultDashboardId).hashCode());
        String $defaultQueueName = this.getDefaultQueueName();
        result = result * 59 + ($defaultQueueName == null ? 43 : $defaultQueueName.hashCode());
        RuleChainId $defaultEdgeRuleChainId = this.getDefaultEdgeRuleChainId();
        result = result * 59 + ($defaultEdgeRuleChainId == null ? 43 : ((Object)$defaultEdgeRuleChainId).hashCode());
        AssetProfileId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }
}

