/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.asset;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.id.AssetId;

@Schema
public class AssetInfo
extends Asset {
    private static final long serialVersionUID = -4094528227011066194L;
    @Schema(description="Title of the Customer that owns the asset.", accessMode=Schema.AccessMode.READ_ONLY)
    private String customerTitle;
    @Schema(description="Indicates special 'Public' Customer that is auto-generated to use the assets on public dashboards.", accessMode=Schema.AccessMode.READ_ONLY)
    private boolean customerIsPublic;
    @Schema(description="Name of the corresponding Asset Profile.", accessMode=Schema.AccessMode.READ_ONLY)
    private String assetProfileName;

    public AssetInfo() {
    }

    public AssetInfo(AssetId assetId) {
        super(assetId);
    }

    public AssetInfo(Asset asset, String customerTitle, boolean customerIsPublic, String assetProfileName) {
        super(asset);
        this.customerTitle = customerTitle;
        this.customerIsPublic = customerIsPublic;
        this.assetProfileName = assetProfileName;
    }

    @Generated
    public String getCustomerTitle() {
        return this.customerTitle;
    }

    @Generated
    public boolean isCustomerIsPublic() {
        return this.customerIsPublic;
    }

    @Generated
    public String getAssetProfileName() {
        return this.assetProfileName;
    }

    @Generated
    public void setCustomerTitle(String customerTitle) {
        this.customerTitle = customerTitle;
    }

    @Generated
    public void setCustomerIsPublic(boolean customerIsPublic) {
        this.customerIsPublic = customerIsPublic;
    }

    @Generated
    public void setAssetProfileName(String assetProfileName) {
        this.assetProfileName = assetProfileName;
    }

    @Override
    @Generated
    public String toString() {
        return "AssetInfo(customerTitle=" + this.getCustomerTitle() + ", customerIsPublic=" + this.isCustomerIsPublic() + ", assetProfileName=" + this.getAssetProfileName() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetInfo)) {
            return false;
        }
        AssetInfo other = (AssetInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isCustomerIsPublic() != other.isCustomerIsPublic()) {
            return false;
        }
        String this$customerTitle = this.getCustomerTitle();
        String other$customerTitle = other.getCustomerTitle();
        if (this$customerTitle == null ? other$customerTitle != null : !this$customerTitle.equals(other$customerTitle)) {
            return false;
        }
        String this$assetProfileName = this.getAssetProfileName();
        String other$assetProfileName = other.getAssetProfileName();
        return !(this$assetProfileName == null ? other$assetProfileName != null : !this$assetProfileName.equals(other$assetProfileName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isCustomerIsPublic() ? 79 : 97);
        String $customerTitle = this.getCustomerTitle();
        result = result * 59 + ($customerTitle == null ? 43 : $customerTitle.hashCode());
        String $assetProfileName = this.getAssetProfileName();
        result = result * 59 + ($assetProfileName == null ? 43 : $assetProfileName.hashCode());
        return result;
    }
}

