/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmModificationRequest;
import org.thingsboard.server.common.data.alarm.AlarmPropagationInfo;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.validation.NoXss;

public class AlarmUpdateRequest
implements AlarmModificationRequest {
    @NotNull
    @Schema(description="JSON object with Tenant Id", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @NotNull
    @Schema(description="JSON object with the alarm Id. Specify this field to update the alarm. Referencing non-existing alarm Id will cause error. Omit this field to create new alarm.")
    private AlarmId alarmId;
    @NotNull
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Alarm severity", example="CRITICAL")
    private AlarmSeverity severity;
    @Schema(description="Timestamp of the alarm start time, in milliseconds", example="1634058704565")
    private long startTs;
    @Schema(description="Timestamp of the alarm end time(last time update), in milliseconds", example="1634111163522")
    private long endTs;
    @NoXss
    @Schema(description="JSON object with alarm details")
    private JsonNode details;
    @Valid
    @Schema(description="JSON object with propagation details")
    private AlarmPropagationInfo propagation;
    private UserId userId;

    public static AlarmUpdateRequest fromAlarm(Alarm a) {
        return AlarmUpdateRequest.fromAlarm(a, null);
    }

    public static AlarmUpdateRequest fromAlarm(Alarm a, UserId userId) {
        return AlarmUpdateRequest.builder().tenantId(a.getTenantId()).alarmId(a.getId()).severity(a.getSeverity()).startTs(a.getStartTs()).endTs(a.getEndTs()).details(a.getDetails()).propagation(AlarmPropagationInfo.builder().propagate(a.isPropagate()).propagateToOwner(a.isPropagateToOwner()).propagateToTenant(a.isPropagateToTenant()).propagateRelationTypes(a.getPropagateRelationTypes()).build()).userId(userId).build();
    }

    @ConstructorProperties(value={"tenantId", "alarmId", "severity", "startTs", "endTs", "details", "propagation", "userId"})
    @Generated
    AlarmUpdateRequest(TenantId tenantId, AlarmId alarmId, AlarmSeverity severity, long startTs, long endTs, JsonNode details, AlarmPropagationInfo propagation, UserId userId) {
        this.tenantId = tenantId;
        this.alarmId = alarmId;
        this.severity = severity;
        this.startTs = startTs;
        this.endTs = endTs;
        this.details = details;
        this.propagation = propagation;
        this.userId = userId;
    }

    @Generated
    public static AlarmUpdateRequestBuilder builder() {
        return new AlarmUpdateRequestBuilder();
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public AlarmId getAlarmId() {
        return this.alarmId;
    }

    @Override
    @Generated
    public AlarmSeverity getSeverity() {
        return this.severity;
    }

    @Override
    @Generated
    public long getStartTs() {
        return this.startTs;
    }

    @Override
    @Generated
    public long getEndTs() {
        return this.endTs;
    }

    @Generated
    public JsonNode getDetails() {
        return this.details;
    }

    @Generated
    public AlarmPropagationInfo getPropagation() {
        return this.propagation;
    }

    @Override
    @Generated
    public UserId getUserId() {
        return this.userId;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setAlarmId(AlarmId alarmId) {
        this.alarmId = alarmId;
    }

    @Generated
    public void setSeverity(AlarmSeverity severity) {
        this.severity = severity;
    }

    @Override
    @Generated
    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    @Override
    @Generated
    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    @Generated
    public void setDetails(JsonNode details) {
        this.details = details;
    }

    @Generated
    public void setPropagation(AlarmPropagationInfo propagation) {
        this.propagation = propagation;
    }

    @Generated
    public void setUserId(UserId userId) {
        this.userId = userId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmUpdateRequest)) {
            return false;
        }
        AlarmUpdateRequest other = (AlarmUpdateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        AlarmId this$alarmId = this.getAlarmId();
        AlarmId other$alarmId = other.getAlarmId();
        if (this$alarmId == null ? other$alarmId != null : !((Object)this$alarmId).equals(other$alarmId)) {
            return false;
        }
        AlarmSeverity this$severity = this.getSeverity();
        AlarmSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        JsonNode this$details = this.getDetails();
        JsonNode other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
            return false;
        }
        AlarmPropagationInfo this$propagation = this.getPropagation();
        AlarmPropagationInfo other$propagation = other.getPropagation();
        if (this$propagation == null ? other$propagation != null : !((Object)this$propagation).equals(other$propagation)) {
            return false;
        }
        UserId this$userId = this.getUserId();
        UserId other$userId = other.getUserId();
        return !(this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlarmUpdateRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        AlarmId $alarmId = this.getAlarmId();
        result = result * 59 + ($alarmId == null ? 43 : ((Object)$alarmId).hashCode());
        AlarmSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        JsonNode $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        AlarmPropagationInfo $propagation = this.getPropagation();
        result = result * 59 + ($propagation == null ? 43 : ((Object)$propagation).hashCode());
        UserId $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AlarmUpdateRequest(tenantId=" + String.valueOf(this.getTenantId()) + ", alarmId=" + String.valueOf(this.getAlarmId()) + ", severity=" + String.valueOf((Object)this.getSeverity()) + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", propagation=" + String.valueOf(this.getPropagation()) + ", userId=" + String.valueOf(this.getUserId()) + ")";
    }

    @Generated
    public static class AlarmUpdateRequestBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private AlarmId alarmId;
        @Generated
        private AlarmSeverity severity;
        @Generated
        private long startTs;
        @Generated
        private long endTs;
        @Generated
        private JsonNode details;
        @Generated
        private AlarmPropagationInfo propagation;
        @Generated
        private UserId userId;

        @Generated
        AlarmUpdateRequestBuilder() {
        }

        @Generated
        public AlarmUpdateRequestBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public AlarmUpdateRequestBuilder alarmId(AlarmId alarmId) {
            this.alarmId = alarmId;
            return this;
        }

        @Generated
        public AlarmUpdateRequestBuilder severity(AlarmSeverity severity) {
            this.severity = severity;
            return this;
        }

        @Generated
        public AlarmUpdateRequestBuilder startTs(long startTs) {
            this.startTs = startTs;
            return this;
        }

        @Generated
        public AlarmUpdateRequestBuilder endTs(long endTs) {
            this.endTs = endTs;
            return this;
        }

        @Generated
        public AlarmUpdateRequestBuilder details(JsonNode details) {
            this.details = details;
            return this;
        }

        @Generated
        public AlarmUpdateRequestBuilder propagation(AlarmPropagationInfo propagation) {
            this.propagation = propagation;
            return this;
        }

        @Generated
        public AlarmUpdateRequestBuilder userId(UserId userId) {
            this.userId = userId;
            return this;
        }

        @Generated
        public AlarmUpdateRequest build() {
            return new AlarmUpdateRequest(this.tenantId, this.alarmId, this.severity, this.startTs, this.endTs, this.details, this.propagation, this.userId);
        }

        @Generated
        public String toString() {
            return "AlarmUpdateRequest.AlarmUpdateRequestBuilder(tenantId=" + String.valueOf(this.tenantId) + ", alarmId=" + String.valueOf(this.alarmId) + ", severity=" + String.valueOf((Object)this.severity) + ", startTs=" + this.startTs + ", endTs=" + this.endTs + ", details=" + String.valueOf(this.details) + ", propagation=" + String.valueOf(this.propagation) + ", userId=" + String.valueOf(this.userId) + ")";
        }
    }
}

