/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmModificationRequest;
import org.thingsboard.server.common.data.alarm.AlarmPropagationInfo;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class AlarmCreateOrUpdateActiveRequest
implements AlarmModificationRequest {
    @NotNull
    @Schema(description="JSON object with Tenant Id", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @Schema(description="JSON object with Customer Id", accessMode=Schema.AccessMode.READ_ONLY)
    private CustomerId customerId;
    @NotNull
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="representing type of the Alarm", example="High Temperature Alarm")
    @Length(fieldName="type")
    private String type;
    @NotNull
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="JSON object with alarm originator id")
    private EntityId originator;
    @NotNull
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Alarm severity", example="CRITICAL")
    private AlarmSeverity severity;
    @Schema(description="Timestamp of the alarm start time, in milliseconds", example="1634058704565")
    private long startTs;
    @Schema(description="Timestamp of the alarm end time(last time update), in milliseconds", example="1634111163522")
    private long endTs;
    @NoXss
    @Schema(description="JSON object with alarm details")
    private JsonNode details;
    @Valid
    @Schema(description="JSON object with propagation details")
    private AlarmPropagationInfo propagation;
    private UserId userId;
    private AlarmId edgeAlarmId;

    public static AlarmCreateOrUpdateActiveRequest fromAlarm(Alarm a) {
        return AlarmCreateOrUpdateActiveRequest.fromAlarm(a, null);
    }

    public static AlarmCreateOrUpdateActiveRequest fromAlarm(Alarm a, UserId userId) {
        return AlarmCreateOrUpdateActiveRequest.fromAlarm(a, userId, null);
    }

    public static AlarmCreateOrUpdateActiveRequest fromAlarm(Alarm a, UserId userId, AlarmId edgeAlarmId) {
        return AlarmCreateOrUpdateActiveRequest.builder().tenantId(a.getTenantId()).customerId(a.getCustomerId()).type(a.getType()).originator(a.getOriginator()).severity(a.getSeverity()).startTs(a.getStartTs()).endTs(a.getEndTs()).details(a.getDetails()).propagation(AlarmPropagationInfo.builder().propagate(a.isPropagate()).propagateToOwner(a.isPropagateToOwner()).propagateToTenant(a.isPropagateToTenant()).propagateRelationTypes(a.getPropagateRelationTypes()).build()).userId(userId).edgeAlarmId(edgeAlarmId).build();
    }

    @ConstructorProperties(value={"tenantId", "customerId", "type", "originator", "severity", "startTs", "endTs", "details", "propagation", "userId", "edgeAlarmId"})
    @Generated
    AlarmCreateOrUpdateActiveRequest(TenantId tenantId, CustomerId customerId, String type, EntityId originator, AlarmSeverity severity, long startTs, long endTs, JsonNode details, AlarmPropagationInfo propagation, UserId userId, AlarmId edgeAlarmId) {
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.type = type;
        this.originator = originator;
        this.severity = severity;
        this.startTs = startTs;
        this.endTs = endTs;
        this.details = details;
        this.propagation = propagation;
        this.userId = userId;
        this.edgeAlarmId = edgeAlarmId;
    }

    @Generated
    public static AlarmCreateOrUpdateActiveRequestBuilder builder() {
        return new AlarmCreateOrUpdateActiveRequestBuilder();
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public EntityId getOriginator() {
        return this.originator;
    }

    @Override
    @Generated
    public AlarmSeverity getSeverity() {
        return this.severity;
    }

    @Override
    @Generated
    public long getStartTs() {
        return this.startTs;
    }

    @Override
    @Generated
    public long getEndTs() {
        return this.endTs;
    }

    @Generated
    public JsonNode getDetails() {
        return this.details;
    }

    @Generated
    public AlarmPropagationInfo getPropagation() {
        return this.propagation;
    }

    @Override
    @Generated
    public UserId getUserId() {
        return this.userId;
    }

    @Generated
    public AlarmId getEdgeAlarmId() {
        return this.edgeAlarmId;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setOriginator(EntityId originator) {
        this.originator = originator;
    }

    @Generated
    public void setSeverity(AlarmSeverity severity) {
        this.severity = severity;
    }

    @Override
    @Generated
    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    @Override
    @Generated
    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    @Generated
    public void setDetails(JsonNode details) {
        this.details = details;
    }

    @Generated
    public void setPropagation(AlarmPropagationInfo propagation) {
        this.propagation = propagation;
    }

    @Generated
    public void setUserId(UserId userId) {
        this.userId = userId;
    }

    @Generated
    public void setEdgeAlarmId(AlarmId edgeAlarmId) {
        this.edgeAlarmId = edgeAlarmId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmCreateOrUpdateActiveRequest)) {
            return false;
        }
        AlarmCreateOrUpdateActiveRequest other = (AlarmCreateOrUpdateActiveRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        EntityId this$originator = this.getOriginator();
        EntityId other$originator = other.getOriginator();
        if (this$originator == null ? other$originator != null : !this$originator.equals(other$originator)) {
            return false;
        }
        AlarmSeverity this$severity = this.getSeverity();
        AlarmSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        JsonNode this$details = this.getDetails();
        JsonNode other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
            return false;
        }
        AlarmPropagationInfo this$propagation = this.getPropagation();
        AlarmPropagationInfo other$propagation = other.getPropagation();
        if (this$propagation == null ? other$propagation != null : !((Object)this$propagation).equals(other$propagation)) {
            return false;
        }
        UserId this$userId = this.getUserId();
        UserId other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        AlarmId this$edgeAlarmId = this.getEdgeAlarmId();
        AlarmId other$edgeAlarmId = other.getEdgeAlarmId();
        return !(this$edgeAlarmId == null ? other$edgeAlarmId != null : !((Object)this$edgeAlarmId).equals(other$edgeAlarmId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlarmCreateOrUpdateActiveRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        EntityId $originator = this.getOriginator();
        result = result * 59 + ($originator == null ? 43 : $originator.hashCode());
        AlarmSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        JsonNode $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        AlarmPropagationInfo $propagation = this.getPropagation();
        result = result * 59 + ($propagation == null ? 43 : ((Object)$propagation).hashCode());
        UserId $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        AlarmId $edgeAlarmId = this.getEdgeAlarmId();
        result = result * 59 + ($edgeAlarmId == null ? 43 : ((Object)$edgeAlarmId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AlarmCreateOrUpdateActiveRequest(tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", type=" + this.getType() + ", originator=" + String.valueOf(this.getOriginator()) + ", severity=" + String.valueOf((Object)this.getSeverity()) + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", propagation=" + String.valueOf(this.getPropagation()) + ", userId=" + String.valueOf(this.getUserId()) + ", edgeAlarmId=" + String.valueOf(this.getEdgeAlarmId()) + ")";
    }

    @Generated
    public static class AlarmCreateOrUpdateActiveRequestBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private CustomerId customerId;
        @Generated
        private String type;
        @Generated
        private EntityId originator;
        @Generated
        private AlarmSeverity severity;
        @Generated
        private long startTs;
        @Generated
        private long endTs;
        @Generated
        private JsonNode details;
        @Generated
        private AlarmPropagationInfo propagation;
        @Generated
        private UserId userId;
        @Generated
        private AlarmId edgeAlarmId;

        @Generated
        AlarmCreateOrUpdateActiveRequestBuilder() {
        }

        @Generated
        public AlarmCreateOrUpdateActiveRequestBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public AlarmCreateOrUpdateActiveRequestBuilder customerId(CustomerId customerId) {
            this.customerId = customerId;
            return this;
        }

        @Generated
        public AlarmCreateOrUpdateActiveRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public AlarmCreateOrUpdateActiveRequestBuilder originator(EntityId originator) {
            this.originator = originator;
            return this;
        }

        @Generated
        public AlarmCreateOrUpdateActiveRequestBuilder severity(AlarmSeverity severity) {
            this.severity = severity;
            return this;
        }

        @Generated
        public AlarmCreateOrUpdateActiveRequestBuilder startTs(long startTs) {
            this.startTs = startTs;
            return this;
        }

        @Generated
        public AlarmCreateOrUpdateActiveRequestBuilder endTs(long endTs) {
            this.endTs = endTs;
            return this;
        }

        @Generated
        public AlarmCreateOrUpdateActiveRequestBuilder details(JsonNode details) {
            this.details = details;
            return this;
        }

        @Generated
        public AlarmCreateOrUpdateActiveRequestBuilder propagation(AlarmPropagationInfo propagation) {
            this.propagation = propagation;
            return this;
        }

        @Generated
        public AlarmCreateOrUpdateActiveRequestBuilder userId(UserId userId) {
            this.userId = userId;
            return this;
        }

        @Generated
        public AlarmCreateOrUpdateActiveRequestBuilder edgeAlarmId(AlarmId edgeAlarmId) {
            this.edgeAlarmId = edgeAlarmId;
            return this;
        }

        @Generated
        public AlarmCreateOrUpdateActiveRequest build() {
            return new AlarmCreateOrUpdateActiveRequest(this.tenantId, this.customerId, this.type, this.originator, this.severity, this.startTs, this.endTs, this.details, this.propagation, this.userId, this.edgeAlarmId);
        }

        @Generated
        public String toString() {
            return "AlarmCreateOrUpdateActiveRequest.AlarmCreateOrUpdateActiveRequestBuilder(tenantId=" + String.valueOf(this.tenantId) + ", customerId=" + String.valueOf(this.customerId) + ", type=" + this.type + ", originator=" + String.valueOf(this.originator) + ", severity=" + String.valueOf((Object)this.severity) + ", startTs=" + this.startTs + ", endTs=" + this.endTs + ", details=" + String.valueOf(this.details) + ", propagation=" + String.valueOf(this.propagation) + ", userId=" + String.valueOf(this.userId) + ", edgeAlarmId=" + String.valueOf(this.edgeAlarmId) + ")";
        }
    }
}

