/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
@JsonIgnoreProperties(ignoreUnknown=true)
public class Alarm
extends BaseData<AlarmId>
implements HasName,
HasTenantId,
HasCustomerId {
    private static final long serialVersionUID = -1935800187424953611L;
    @Schema(description="JSON object with Tenant Id", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @Schema(description="JSON object with Customer Id", accessMode=Schema.AccessMode.READ_ONLY)
    private CustomerId customerId;
    @NoXss
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="representing type of the Alarm", example="High Temperature Alarm")
    @Length(fieldName="type")
    private String type;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="JSON object with alarm originator id")
    private EntityId originator;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Alarm severity", example="CRITICAL")
    private AlarmSeverity severity;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Acknowledged", example="true")
    private boolean acknowledged;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Cleared", example="false")
    private boolean cleared;
    @Schema(description="Alarm assignee user id")
    private UserId assigneeId;
    @Schema(description="Timestamp of the alarm start time, in milliseconds", example="1634058704565")
    private long startTs;
    @Schema(description="Timestamp of the alarm end time(last time update), in milliseconds", example="1634111163522")
    private long endTs;
    @Schema(description="Timestamp of the alarm acknowledgement, in milliseconds", example="1634115221948")
    private long ackTs;
    @Schema(description="Timestamp of the alarm clearing, in milliseconds", example="1634114528465")
    private long clearTs;
    @Schema(description="Timestamp of the alarm assignment, in milliseconds", example="1634115928465")
    private long assignTs;
    @Schema(description="JSON object with alarm details")
    private transient JsonNode details;
    @Schema(description="Propagation flag to specify if alarm should be propagated to parent entities of alarm originator", example="true")
    private boolean propagate;
    @Schema(description="Propagation flag to specify if alarm should be propagated to the owner (tenant or customer) of alarm originator", example="true")
    private boolean propagateToOwner;
    @Schema(description="Propagation flag to specify if alarm should be propagated to the tenant entity", example="true")
    private boolean propagateToTenant;
    @Schema(description="JSON array of relation types that should be used for propagation. By default, 'propagateRelationTypes' array is empty which means that the alarm will be propagated based on any relation type to parent entities. This parameter should be used only in case when 'propagate' parameter is set to true, otherwise, 'propagateRelationTypes' array will be ignored.")
    private List<String> propagateRelationTypes;

    public Alarm() {
    }

    public Alarm(AlarmId id) {
        super(id);
    }

    public Alarm(Alarm alarm) {
        super(alarm.getId());
        this.createdTime = alarm.getCreatedTime();
        this.tenantId = alarm.getTenantId();
        this.customerId = alarm.getCustomerId();
        this.type = alarm.getType();
        this.originator = alarm.getOriginator();
        this.severity = alarm.getSeverity();
        this.assigneeId = alarm.getAssigneeId();
        this.startTs = alarm.getStartTs();
        this.endTs = alarm.getEndTs();
        this.acknowledged = alarm.isAcknowledged();
        this.ackTs = alarm.getAckTs();
        this.clearTs = alarm.getClearTs();
        this.cleared = alarm.isCleared();
        this.assignTs = alarm.getAssignTs();
        this.details = alarm.getDetails();
        this.propagate = alarm.isPropagate();
        this.propagateToOwner = alarm.isPropagateToOwner();
        this.propagateToTenant = alarm.isPropagateToTenant();
        this.propagateRelationTypes = alarm.getPropagateRelationTypes();
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="representing type of the Alarm", example="High Temperature Alarm")
    public String getName() {
        return this.type;
    }

    @Override
    @Schema(description="JSON object with the alarm Id. Specify this field to update the alarm. Referencing non-existing alarm Id will cause error. Omit this field to create new alarm.")
    public AlarmId getId() {
        return (AlarmId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the alarm creation, in milliseconds", example="1634058704567", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="status of the Alarm", example="ACTIVE_UNACK", accessMode=Schema.AccessMode.READ_ONLY)
    public AlarmStatus getStatus() {
        return Alarm.toStatus(this.cleared, this.acknowledged);
    }

    public static AlarmStatus toStatus(boolean cleared, boolean acknowledged) {
        if (cleared) {
            return acknowledged ? AlarmStatus.CLEARED_ACK : AlarmStatus.CLEARED_UNACK;
        }
        return acknowledged ? AlarmStatus.ACTIVE_ACK : AlarmStatus.ACTIVE_UNACK;
    }

    @JsonIgnore
    public DashboardId getDashboardId() {
        return Optional.ofNullable(this.getDetails()).map(details -> details.get("dashboardId")).filter(JsonNode::isTextual).map(id -> new DashboardId(UUID.fromString(id.asText()))).orElse(null);
    }

    @Generated
    public static AlarmBuilder builder() {
        return new AlarmBuilder();
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public EntityId getOriginator() {
        return this.originator;
    }

    @Generated
    public AlarmSeverity getSeverity() {
        return this.severity;
    }

    @Generated
    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    @Generated
    public boolean isCleared() {
        return this.cleared;
    }

    @Generated
    public UserId getAssigneeId() {
        return this.assigneeId;
    }

    @Generated
    public long getStartTs() {
        return this.startTs;
    }

    @Generated
    public long getEndTs() {
        return this.endTs;
    }

    @Generated
    public long getAckTs() {
        return this.ackTs;
    }

    @Generated
    public long getClearTs() {
        return this.clearTs;
    }

    @Generated
    public long getAssignTs() {
        return this.assignTs;
    }

    @Generated
    public JsonNode getDetails() {
        return this.details;
    }

    @Generated
    public boolean isPropagate() {
        return this.propagate;
    }

    @Generated
    public boolean isPropagateToOwner() {
        return this.propagateToOwner;
    }

    @Generated
    public boolean isPropagateToTenant() {
        return this.propagateToTenant;
    }

    @Generated
    public List<String> getPropagateRelationTypes() {
        return this.propagateRelationTypes;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setOriginator(EntityId originator) {
        this.originator = originator;
    }

    @Generated
    public void setSeverity(AlarmSeverity severity) {
        this.severity = severity;
    }

    @Generated
    public void setAcknowledged(boolean acknowledged) {
        this.acknowledged = acknowledged;
    }

    @Generated
    public void setCleared(boolean cleared) {
        this.cleared = cleared;
    }

    @Generated
    public void setAssigneeId(UserId assigneeId) {
        this.assigneeId = assigneeId;
    }

    @Generated
    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    @Generated
    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    @Generated
    public void setAckTs(long ackTs) {
        this.ackTs = ackTs;
    }

    @Generated
    public void setClearTs(long clearTs) {
        this.clearTs = clearTs;
    }

    @Generated
    public void setAssignTs(long assignTs) {
        this.assignTs = assignTs;
    }

    @Generated
    public void setDetails(JsonNode details) {
        this.details = details;
    }

    @Generated
    public void setPropagate(boolean propagate) {
        this.propagate = propagate;
    }

    @Generated
    public void setPropagateToOwner(boolean propagateToOwner) {
        this.propagateToOwner = propagateToOwner;
    }

    @Generated
    public void setPropagateToTenant(boolean propagateToTenant) {
        this.propagateToTenant = propagateToTenant;
    }

    @Generated
    public void setPropagateRelationTypes(List<String> propagateRelationTypes) {
        this.propagateRelationTypes = propagateRelationTypes;
    }

    @Override
    @Generated
    public String toString() {
        return "Alarm(tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", type=" + this.getType() + ", originator=" + String.valueOf(this.getOriginator()) + ", severity=" + String.valueOf((Object)this.getSeverity()) + ", acknowledged=" + this.isAcknowledged() + ", cleared=" + this.isCleared() + ", assigneeId=" + String.valueOf(this.getAssigneeId()) + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", ackTs=" + this.getAckTs() + ", clearTs=" + this.getClearTs() + ", assignTs=" + this.getAssignTs() + ", details=" + String.valueOf(this.getDetails()) + ", propagate=" + this.isPropagate() + ", propagateToOwner=" + this.isPropagateToOwner() + ", propagateToTenant=" + this.isPropagateToTenant() + ", propagateRelationTypes=" + String.valueOf(this.getPropagateRelationTypes()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Alarm)) {
            return false;
        }
        Alarm other = (Alarm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAcknowledged() != other.isAcknowledged()) {
            return false;
        }
        if (this.isCleared() != other.isCleared()) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        if (this.getAckTs() != other.getAckTs()) {
            return false;
        }
        if (this.getClearTs() != other.getClearTs()) {
            return false;
        }
        if (this.getAssignTs() != other.getAssignTs()) {
            return false;
        }
        if (this.isPropagate() != other.isPropagate()) {
            return false;
        }
        if (this.isPropagateToOwner() != other.isPropagateToOwner()) {
            return false;
        }
        if (this.isPropagateToTenant() != other.isPropagateToTenant()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        EntityId this$originator = this.getOriginator();
        EntityId other$originator = other.getOriginator();
        if (this$originator == null ? other$originator != null : !this$originator.equals(other$originator)) {
            return false;
        }
        AlarmSeverity this$severity = this.getSeverity();
        AlarmSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        UserId this$assigneeId = this.getAssigneeId();
        UserId other$assigneeId = other.getAssigneeId();
        if (this$assigneeId == null ? other$assigneeId != null : !((Object)this$assigneeId).equals(other$assigneeId)) {
            return false;
        }
        List<String> this$propagateRelationTypes = this.getPropagateRelationTypes();
        List<String> other$propagateRelationTypes = other.getPropagateRelationTypes();
        return !(this$propagateRelationTypes == null ? other$propagateRelationTypes != null : !((Object)this$propagateRelationTypes).equals(other$propagateRelationTypes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Alarm;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAcknowledged() ? 79 : 97);
        result = result * 59 + (this.isCleared() ? 79 : 97);
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        long $ackTs = this.getAckTs();
        result = result * 59 + (int)($ackTs >>> 32 ^ $ackTs);
        long $clearTs = this.getClearTs();
        result = result * 59 + (int)($clearTs >>> 32 ^ $clearTs);
        long $assignTs = this.getAssignTs();
        result = result * 59 + (int)($assignTs >>> 32 ^ $assignTs);
        result = result * 59 + (this.isPropagate() ? 79 : 97);
        result = result * 59 + (this.isPropagateToOwner() ? 79 : 97);
        result = result * 59 + (this.isPropagateToTenant() ? 79 : 97);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        EntityId $originator = this.getOriginator();
        result = result * 59 + ($originator == null ? 43 : $originator.hashCode());
        AlarmSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        UserId $assigneeId = this.getAssigneeId();
        result = result * 59 + ($assigneeId == null ? 43 : ((Object)$assigneeId).hashCode());
        List<String> $propagateRelationTypes = this.getPropagateRelationTypes();
        result = result * 59 + ($propagateRelationTypes == null ? 43 : ((Object)$propagateRelationTypes).hashCode());
        return result;
    }

    @ConstructorProperties(value={"tenantId", "customerId", "type", "originator", "severity", "acknowledged", "cleared", "assigneeId", "startTs", "endTs", "ackTs", "clearTs", "assignTs", "details", "propagate", "propagateToOwner", "propagateToTenant", "propagateRelationTypes"})
    @Generated
    public Alarm(TenantId tenantId, CustomerId customerId, String type, EntityId originator, AlarmSeverity severity, boolean acknowledged, boolean cleared, UserId assigneeId, long startTs, long endTs, long ackTs, long clearTs, long assignTs, JsonNode details, boolean propagate, boolean propagateToOwner, boolean propagateToTenant, List<String> propagateRelationTypes) {
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.type = type;
        this.originator = originator;
        this.severity = severity;
        this.acknowledged = acknowledged;
        this.cleared = cleared;
        this.assigneeId = assigneeId;
        this.startTs = startTs;
        this.endTs = endTs;
        this.ackTs = ackTs;
        this.clearTs = clearTs;
        this.assignTs = assignTs;
        this.details = details;
        this.propagate = propagate;
        this.propagateToOwner = propagateToOwner;
        this.propagateToTenant = propagateToTenant;
        this.propagateRelationTypes = propagateRelationTypes;
    }

    @Generated
    public static class AlarmBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private CustomerId customerId;
        @Generated
        private String type;
        @Generated
        private EntityId originator;
        @Generated
        private AlarmSeverity severity;
        @Generated
        private boolean acknowledged;
        @Generated
        private boolean cleared;
        @Generated
        private UserId assigneeId;
        @Generated
        private long startTs;
        @Generated
        private long endTs;
        @Generated
        private long ackTs;
        @Generated
        private long clearTs;
        @Generated
        private long assignTs;
        @Generated
        private JsonNode details;
        @Generated
        private boolean propagate;
        @Generated
        private boolean propagateToOwner;
        @Generated
        private boolean propagateToTenant;
        @Generated
        private List<String> propagateRelationTypes;

        @Generated
        AlarmBuilder() {
        }

        @Generated
        public AlarmBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public AlarmBuilder customerId(CustomerId customerId) {
            this.customerId = customerId;
            return this;
        }

        @Generated
        public AlarmBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public AlarmBuilder originator(EntityId originator) {
            this.originator = originator;
            return this;
        }

        @Generated
        public AlarmBuilder severity(AlarmSeverity severity) {
            this.severity = severity;
            return this;
        }

        @Generated
        public AlarmBuilder acknowledged(boolean acknowledged) {
            this.acknowledged = acknowledged;
            return this;
        }

        @Generated
        public AlarmBuilder cleared(boolean cleared) {
            this.cleared = cleared;
            return this;
        }

        @Generated
        public AlarmBuilder assigneeId(UserId assigneeId) {
            this.assigneeId = assigneeId;
            return this;
        }

        @Generated
        public AlarmBuilder startTs(long startTs) {
            this.startTs = startTs;
            return this;
        }

        @Generated
        public AlarmBuilder endTs(long endTs) {
            this.endTs = endTs;
            return this;
        }

        @Generated
        public AlarmBuilder ackTs(long ackTs) {
            this.ackTs = ackTs;
            return this;
        }

        @Generated
        public AlarmBuilder clearTs(long clearTs) {
            this.clearTs = clearTs;
            return this;
        }

        @Generated
        public AlarmBuilder assignTs(long assignTs) {
            this.assignTs = assignTs;
            return this;
        }

        @Generated
        public AlarmBuilder details(JsonNode details) {
            this.details = details;
            return this;
        }

        @Generated
        public AlarmBuilder propagate(boolean propagate) {
            this.propagate = propagate;
            return this;
        }

        @Generated
        public AlarmBuilder propagateToOwner(boolean propagateToOwner) {
            this.propagateToOwner = propagateToOwner;
            return this;
        }

        @Generated
        public AlarmBuilder propagateToTenant(boolean propagateToTenant) {
            this.propagateToTenant = propagateToTenant;
            return this;
        }

        @Generated
        public AlarmBuilder propagateRelationTypes(List<String> propagateRelationTypes) {
            this.propagateRelationTypes = propagateRelationTypes;
            return this;
        }

        @Generated
        public Alarm build() {
            return new Alarm(this.tenantId, this.customerId, this.type, this.originator, this.severity, this.acknowledged, this.cleared, this.assigneeId, this.startTs, this.endTs, this.ackTs, this.clearTs, this.assignTs, this.details, this.propagate, this.propagateToOwner, this.propagateToTenant, this.propagateRelationTypes);
        }

        @Generated
        public String toString() {
            return "Alarm.AlarmBuilder(tenantId=" + String.valueOf(this.tenantId) + ", customerId=" + String.valueOf(this.customerId) + ", type=" + this.type + ", originator=" + String.valueOf(this.originator) + ", severity=" + String.valueOf((Object)this.severity) + ", acknowledged=" + this.acknowledged + ", cleared=" + this.cleared + ", assigneeId=" + String.valueOf(this.assigneeId) + ", startTs=" + this.startTs + ", endTs=" + this.endTs + ", ackTs=" + this.ackTs + ", clearTs=" + this.clearTs + ", assignTs=" + this.assignTs + ", details=" + String.valueOf(this.details) + ", propagate=" + this.propagate + ", propagateToOwner=" + this.propagateToOwner + ", propagateToTenant=" + this.propagateToTenant + ", propagateRelationTypes=" + String.valueOf(this.propagateRelationTypes) + ")";
        }
    }
}

