/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.ai.provider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.validation.constraints.AssertTrue;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.thingsboard.server.common.data.ai.provider.AiProviderConfig;

public record OpenAiProviderConfig(String baseUrl, String apiKey) implements AiProviderConfig
{
    public static final String OPENAI_OFFICIAL_BASE_URL = "https://api.openai.com/v1";

    public OpenAiProviderConfig(String baseUrl, String apiKey) {
        this.baseUrl = baseUrl = Objects.requireNonNullElse(baseUrl, OPENAI_OFFICIAL_BASE_URL);
        this.apiKey = apiKey;
    }

    @JsonIgnore
    @AssertTrue(message="API key is required when using the official OpenAI API")
    public @AssertTrue(message="API key is required when using the official OpenAI API") boolean isValid() {
        if (this.baseUrl.equals(OPENAI_OFFICIAL_BASE_URL)) {
            return StringUtils.isNotBlank((CharSequence)this.apiKey);
        }
        return true;
    }

    @Generated
    public static OpenAiProviderConfigBuilder builder() {
        return new OpenAiProviderConfigBuilder();
    }

    @Generated
    public static class OpenAiProviderConfigBuilder {
        @Generated
        private String baseUrl;
        @Generated
        private String apiKey;

        @Generated
        OpenAiProviderConfigBuilder() {
        }

        @Generated
        public OpenAiProviderConfigBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public OpenAiProviderConfigBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public OpenAiProviderConfig build() {
            return new OpenAiProviderConfig(this.baseUrl, this.apiKey);
        }

        @Generated
        public String toString() {
            return "OpenAiProviderConfig.OpenAiProviderConfigBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ")";
        }
    }
}

