/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.ai.model.chat;

import dev.langchain4j.model.chat.ChatModel;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import lombok.Generated;
import org.thingsboard.server.common.data.ai.model.chat.AiChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.Langchain4jChatModelConfigurer;
import org.thingsboard.server.common.data.ai.provider.AiProvider;
import org.thingsboard.server.common.data.ai.provider.AzureOpenAiProviderConfig;

public final class AzureOpenAiChatModelConfig
extends Record
implements AiChatModelConfig<AzureOpenAiChatModelConfig> {
    @NotNull
    @Valid
    private final AzureOpenAiProviderConfig providerConfig;
    @NotBlank
    private final String modelId;
    @PositiveOrZero
    private final Double temperature;
    @Positive
    @Max(value=1L)
    private final @Positive @Max(value=1L) Double topP;
    private final Double frequencyPenalty;
    private final Double presencePenalty;
    private final Integer maxOutputTokens;
    @Positive
    private final Integer timeoutSeconds;
    @PositiveOrZero
    private final Integer maxRetries;

    public AzureOpenAiChatModelConfig(@NotNull @Valid AzureOpenAiProviderConfig providerConfig, @NotBlank String modelId, @PositiveOrZero Double temperature, @Positive @Max(value=1L) @Positive @Max(value=1L) Double topP, Double frequencyPenalty, Double presencePenalty, Integer maxOutputTokens, @Positive Integer timeoutSeconds, @PositiveOrZero Integer maxRetries) {
        this.providerConfig = providerConfig;
        this.modelId = modelId;
        this.temperature = temperature;
        this.topP = topP;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.maxOutputTokens = maxOutputTokens;
        this.timeoutSeconds = timeoutSeconds;
        this.maxRetries = maxRetries;
    }

    @Override
    public AiProvider provider() {
        return AiProvider.AZURE_OPENAI;
    }

    @Override
    public ChatModel configure(Langchain4jChatModelConfigurer configurer) {
        return configurer.configureChatModel(this);
    }

    @Override
    public boolean supportsJsonMode() {
        return true;
    }

    @Generated
    public static AzureOpenAiChatModelConfigBuilder builder() {
        return new AzureOpenAiChatModelConfigBuilder();
    }

    @Override
    @Generated
    public AzureOpenAiChatModelConfig withTimeoutSeconds(Integer timeoutSeconds) {
        return this.timeoutSeconds == timeoutSeconds ? this : new AzureOpenAiChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.frequencyPenalty, this.presencePenalty, this.maxOutputTokens, timeoutSeconds, this.maxRetries);
    }

    @Override
    @Generated
    public AzureOpenAiChatModelConfig withMaxRetries(Integer maxRetries) {
        return this.maxRetries == maxRetries ? this : new AzureOpenAiChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.frequencyPenalty, this.presencePenalty, this.maxOutputTokens, this.timeoutSeconds, maxRetries);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{AzureOpenAiChatModelConfig.class, "providerConfig;modelId;temperature;topP;frequencyPenalty;presencePenalty;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "frequencyPenalty", "presencePenalty", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AzureOpenAiChatModelConfig.class, "providerConfig;modelId;temperature;topP;frequencyPenalty;presencePenalty;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "frequencyPenalty", "presencePenalty", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AzureOpenAiChatModelConfig.class, "providerConfig;modelId;temperature;topP;frequencyPenalty;presencePenalty;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "frequencyPenalty", "presencePenalty", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this, o);
    }

    @Override
    @NotNull
    @Valid
    public AzureOpenAiProviderConfig providerConfig() {
        return this.providerConfig;
    }

    @NotBlank
    public String modelId() {
        return this.modelId;
    }

    @PositiveOrZero
    public Double temperature() {
        return this.temperature;
    }

    @Positive
    @Max(value=1L)
    public @Positive @Max(value=1L) Double topP() {
        return this.topP;
    }

    public Double frequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Double presencePenalty() {
        return this.presencePenalty;
    }

    public Integer maxOutputTokens() {
        return this.maxOutputTokens;
    }

    @Override
    @Positive
    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    @PositiveOrZero
    public Integer maxRetries() {
        return this.maxRetries;
    }

    @Generated
    public static class AzureOpenAiChatModelConfigBuilder {
        @Generated
        private AzureOpenAiProviderConfig providerConfig;
        @Generated
        private String modelId;
        @Generated
        private Double temperature;
        @Generated
        private Double topP;
        @Generated
        private Double frequencyPenalty;
        @Generated
        private Double presencePenalty;
        @Generated
        private Integer maxOutputTokens;
        @Generated
        private Integer timeoutSeconds;
        @Generated
        private Integer maxRetries;

        @Generated
        AzureOpenAiChatModelConfigBuilder() {
        }

        @Generated
        public AzureOpenAiChatModelConfigBuilder providerConfig(AzureOpenAiProviderConfig providerConfig) {
            this.providerConfig = providerConfig;
            return this;
        }

        @Generated
        public AzureOpenAiChatModelConfigBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public AzureOpenAiChatModelConfigBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public AzureOpenAiChatModelConfigBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public AzureOpenAiChatModelConfigBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @Generated
        public AzureOpenAiChatModelConfigBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @Generated
        public AzureOpenAiChatModelConfigBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        @Generated
        public AzureOpenAiChatModelConfigBuilder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        @Generated
        public AzureOpenAiChatModelConfigBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public AzureOpenAiChatModelConfig build() {
            return new AzureOpenAiChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.frequencyPenalty, this.presencePenalty, this.maxOutputTokens, this.timeoutSeconds, this.maxRetries);
        }

        @Generated
        public String toString() {
            return "AzureOpenAiChatModelConfig.AzureOpenAiChatModelConfigBuilder(providerConfig=" + String.valueOf(this.providerConfig) + ", modelId=" + this.modelId + ", temperature=" + this.temperature + ", topP=" + this.topP + ", frequencyPenalty=" + this.frequencyPenalty + ", presencePenalty=" + this.presencePenalty + ", maxOutputTokens=" + this.maxOutputTokens + ", timeoutSeconds=" + this.timeoutSeconds + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

