/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.ai.model.chat;

import dev.langchain4j.model.chat.ChatModel;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import lombok.Generated;
import org.thingsboard.server.common.data.ai.model.chat.AiChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.Langchain4jChatModelConfigurer;
import org.thingsboard.server.common.data.ai.provider.AiProvider;
import org.thingsboard.server.common.data.ai.provider.AmazonBedrockProviderConfig;

public final class AmazonBedrockChatModelConfig
extends Record
implements AiChatModelConfig<AmazonBedrockChatModelConfig> {
    @NotNull
    @Valid
    private final AmazonBedrockProviderConfig providerConfig;
    @NotBlank
    private final String modelId;
    @PositiveOrZero
    private final Double temperature;
    @Positive
    @Max(value=1L)
    private final @Positive @Max(value=1L) Double topP;
    private final Integer maxOutputTokens;
    @Positive
    private final Integer timeoutSeconds;
    @PositiveOrZero
    private final Integer maxRetries;

    public AmazonBedrockChatModelConfig(@NotNull @Valid AmazonBedrockProviderConfig providerConfig, @NotBlank String modelId, @PositiveOrZero Double temperature, @Positive @Max(value=1L) @Positive @Max(value=1L) Double topP, Integer maxOutputTokens, @Positive Integer timeoutSeconds, @PositiveOrZero Integer maxRetries) {
        this.providerConfig = providerConfig;
        this.modelId = modelId;
        this.temperature = temperature;
        this.topP = topP;
        this.maxOutputTokens = maxOutputTokens;
        this.timeoutSeconds = timeoutSeconds;
        this.maxRetries = maxRetries;
    }

    @Override
    public AiProvider provider() {
        return AiProvider.AMAZON_BEDROCK;
    }

    @Override
    public ChatModel configure(Langchain4jChatModelConfigurer configurer) {
        return configurer.configureChatModel(this);
    }

    @Override
    public boolean supportsJsonMode() {
        return false;
    }

    @Generated
    public static AmazonBedrockChatModelConfigBuilder builder() {
        return new AmazonBedrockChatModelConfigBuilder();
    }

    @Override
    @Generated
    public AmazonBedrockChatModelConfig withTimeoutSeconds(Integer timeoutSeconds) {
        return this.timeoutSeconds == timeoutSeconds ? this : new AmazonBedrockChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.maxOutputTokens, timeoutSeconds, this.maxRetries);
    }

    @Override
    @Generated
    public AmazonBedrockChatModelConfig withMaxRetries(Integer maxRetries) {
        return this.maxRetries == maxRetries ? this : new AmazonBedrockChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.maxOutputTokens, this.timeoutSeconds, maxRetries);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{AmazonBedrockChatModelConfig.class, "providerConfig;modelId;temperature;topP;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AmazonBedrockChatModelConfig.class, "providerConfig;modelId;temperature;topP;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AmazonBedrockChatModelConfig.class, "providerConfig;modelId;temperature;topP;maxOutputTokens;timeoutSeconds;maxRetries", "providerConfig", "modelId", "temperature", "topP", "maxOutputTokens", "timeoutSeconds", "maxRetries"}, this, o);
    }

    @Override
    @NotNull
    @Valid
    public AmazonBedrockProviderConfig providerConfig() {
        return this.providerConfig;
    }

    @NotBlank
    public String modelId() {
        return this.modelId;
    }

    @PositiveOrZero
    public Double temperature() {
        return this.temperature;
    }

    @Positive
    @Max(value=1L)
    public @Positive @Max(value=1L) Double topP() {
        return this.topP;
    }

    public Integer maxOutputTokens() {
        return this.maxOutputTokens;
    }

    @Override
    @Positive
    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    @PositiveOrZero
    public Integer maxRetries() {
        return this.maxRetries;
    }

    @Generated
    public static class AmazonBedrockChatModelConfigBuilder {
        @Generated
        private AmazonBedrockProviderConfig providerConfig;
        @Generated
        private String modelId;
        @Generated
        private Double temperature;
        @Generated
        private Double topP;
        @Generated
        private Integer maxOutputTokens;
        @Generated
        private Integer timeoutSeconds;
        @Generated
        private Integer maxRetries;

        @Generated
        AmazonBedrockChatModelConfigBuilder() {
        }

        @Generated
        public AmazonBedrockChatModelConfigBuilder providerConfig(AmazonBedrockProviderConfig providerConfig) {
            this.providerConfig = providerConfig;
            return this;
        }

        @Generated
        public AmazonBedrockChatModelConfigBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public AmazonBedrockChatModelConfigBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public AmazonBedrockChatModelConfigBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public AmazonBedrockChatModelConfigBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        @Generated
        public AmazonBedrockChatModelConfigBuilder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        @Generated
        public AmazonBedrockChatModelConfigBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public AmazonBedrockChatModelConfig build() {
            return new AmazonBedrockChatModelConfig(this.providerConfig, this.modelId, this.temperature, this.topP, this.maxOutputTokens, this.timeoutSeconds, this.maxRetries);
        }

        @Generated
        public String toString() {
            return "AmazonBedrockChatModelConfig.AmazonBedrockChatModelConfigBuilder(providerConfig=" + String.valueOf(this.providerConfig) + ", modelId=" + this.modelId + ", temperature=" + this.temperature + ", topP=" + this.topP + ", maxOutputTokens=" + this.maxOutputTokens + ", timeoutSeconds=" + this.timeoutSeconds + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

