/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.ContactBased;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.HasTitle;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class Tenant
extends ContactBased<TenantId>
implements HasTenantId,
HasTitle,
HasVersion {
    private static final long serialVersionUID = 8057243243859922101L;
    @Length(fieldName="title")
    @NoXss
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Title of the tenant", example="Company A")
    private String title;
    @NoXss
    @Length(fieldName="region")
    @Schema(description="Geo region of the tenant", example="North America")
    private String region;
    @Schema(description="JSON object with Tenant Profile Id")
    private TenantProfileId tenantProfileId;
    private Long version;

    public Tenant() {
    }

    public Tenant(TenantId id) {
        super(id);
    }

    public Tenant(Tenant tenant) {
        super(tenant);
        this.title = tenant.getTitle();
        this.region = tenant.getRegion();
        this.tenantProfileId = tenant.getTenantProfileId();
        this.version = tenant.getVersion();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @JsonIgnore
    public TenantId getTenantId() {
        return this.getId();
    }

    @Override
    @Schema(description="Name of the tenant. Read-only, duplicated from title for backward compatibility", example="Company A", accessMode=Schema.AccessMode.READ_ONLY)
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.title;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public TenantProfileId getTenantProfileId() {
        return this.tenantProfileId;
    }

    public void setTenantProfileId(TenantProfileId tenantProfileId) {
        this.tenantProfileId = tenantProfileId;
    }

    @Override
    @Schema(description="JSON object with the tenant Id. Specify this field to update the tenant. Referencing non-existing tenant Id will cause error. Omit this field to create new tenant.")
    public TenantId getId() {
        return (TenantId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the tenant creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Schema(description="Country", example="US")
    public String getCountry() {
        return super.getCountry();
    }

    @Override
    @Schema(description="State", example="NY")
    public String getState() {
        return super.getState();
    }

    @Override
    @Schema(description="City", example="New York")
    public String getCity() {
        return super.getCity();
    }

    @Override
    @Schema(description="Address Line 1", example="42 Broadway Suite 12-400")
    public String getAddress() {
        return super.getAddress();
    }

    @Override
    @Schema(description="Address Line 2", example="")
    public String getAddress2() {
        return super.getAddress2();
    }

    @Override
    @Schema(description="Zip code", example="10004")
    public String getZip() {
        return super.getZip();
    }

    @Override
    @Schema(description="Phone number", example="+1(415)777-7777")
    public String getPhone() {
        return super.getPhone();
    }

    @Override
    @Schema(description="Email", example="example@company.com")
    public String getEmail() {
        return super.getEmail();
    }

    @Override
    @Schema(description="Additional parameters of the device", implementation=JsonNode.class)
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Tenant [title=");
        builder.append(this.title);
        builder.append(", region=");
        builder.append(this.region);
        builder.append(", tenantProfileId=");
        builder.append(this.tenantProfileId);
        builder.append(", additionalInfo=");
        builder.append(this.getAdditionalInfo());
        builder.append(", country=");
        builder.append(this.country);
        builder.append(", state=");
        builder.append(this.state);
        builder.append(", city=");
        builder.append(this.city);
        builder.append(", address=");
        builder.append(this.address);
        builder.append(", address2=");
        builder.append(this.address2);
        builder.append(", zip=");
        builder.append(this.zip);
        builder.append(", phone=");
        builder.append(this.phone);
        builder.append(", email=");
        builder.append(this.email);
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tenant)) {
            return false;
        }
        Tenant other = (Tenant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        TenantProfileId this$tenantProfileId = this.getTenantProfileId();
        TenantProfileId other$tenantProfileId = other.getTenantProfileId();
        return !(this$tenantProfileId == null ? other$tenantProfileId != null : !((Object)this$tenantProfileId).equals(other$tenantProfileId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Tenant;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        TenantProfileId $tenantProfileId = this.getTenantProfileId();
        result = result * 59 + ($tenantProfileId == null ? 43 : ((Object)$tenantProfileId).hashCode());
        return result;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }
}

