/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import java.io.Serializable;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;

public class ProfileEntityIdInfo
implements Serializable,
HasTenantId {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileEntityIdInfo.class);
    private static final long serialVersionUID = 8532058281983868003L;
    private final TenantId tenantId;
    private final EntityId profileId;
    private final EntityId entityId;

    private ProfileEntityIdInfo(UUID tenantId, EntityId profileId, EntityId entityId) {
        this.tenantId = TenantId.fromUUID(tenantId);
        this.profileId = profileId;
        this.entityId = entityId;
    }

    public static ProfileEntityIdInfo create(UUID tenantId, DeviceProfileId profileId, DeviceId entityId) {
        return new ProfileEntityIdInfo(tenantId, profileId, entityId);
    }

    public static ProfileEntityIdInfo create(UUID tenantId, AssetProfileId profileId, AssetId entityId) {
        return new ProfileEntityIdInfo(tenantId, profileId, entityId);
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public EntityId getProfileId() {
        return this.profileId;
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfileEntityIdInfo)) {
            return false;
        }
        ProfileEntityIdInfo other = (ProfileEntityIdInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        EntityId this$profileId = this.getProfileId();
        EntityId other$profileId = other.getProfileId();
        if (this$profileId == null ? other$profileId != null : !this$profileId.equals(other$profileId)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        return !(this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProfileEntityIdInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        EntityId $profileId = this.getProfileId();
        result = result * 59 + ($profileId == null ? 43 : $profileId.hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProfileEntityIdInfo(tenantId=" + String.valueOf(this.getTenantId()) + ", profileId=" + String.valueOf(this.getProfileId()) + ", entityId=" + String.valueOf(this.getEntityId()) + ")";
    }
}

