/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSerDesUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavaSerDesUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T decode(byte[] byteArray) {
        if (byteArray == null) return null;
        if (byteArray.length == 0) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(byteArray);
        try (ObjectInputStream ois = new ObjectInputStream(is);){
            Object object = ois.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            log.error("Error during deserialization", (Throwable)e);
            return null;
        }
    }

    public static <T> byte[] encode(T msq) {
        byte[] byArray;
        if (msq == null) {
            return null;
        }
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        ObjectOutputStream ois = new ObjectOutputStream(boas);
        try {
            ois.writeObject(msq);
            byArray = boas.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("Error during serialization", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        ois.close();
        return byArray;
    }
}

