/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.DeviceProfileProvisionType;
import org.thingsboard.server.common.data.DeviceProfileType;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasDefaultOption;
import org.thingsboard.server.common.data.HasImage;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOtaPackage;
import org.thingsboard.server.common.data.HasRuleEngineProfile;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.device.profile.DeviceProfileData;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class DeviceProfile
extends BaseData<DeviceProfileId>
implements HasName,
HasTenantId,
HasOtaPackage,
HasRuleEngineProfile,
ExportableEntity<DeviceProfileId>,
HasImage,
HasDefaultOption,
HasVersion {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceProfile.class);
    private static final long serialVersionUID = 6998485460273302018L;
    @Schema(description="JSON object with Tenant Id that owns the profile.", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="name")
    @Schema(description="Unique Device Profile Name in scope of Tenant.", example="Moisture Sensor")
    private String name;
    @NoXss
    @Schema(description="Device Profile description. ")
    private String description;
    @Schema(description="Either URL or Base64 data of the icon. Used in the mobile application to visualize set of device profiles in the grid view. ")
    private String image;
    private boolean isDefault;
    @Schema(description="Type of the profile. Always 'DEFAULT' for now. Reserved for future use.")
    private DeviceProfileType type;
    @Schema(description="Type of the transport used to connect the device. Default transport supports HTTP, CoAP and MQTT.")
    private DeviceTransportType transportType;
    @Schema(description="Provisioning strategy.")
    private DeviceProfileProvisionType provisionType;
    @Schema(description="Reference to the rule chain. If present, the specified rule chain will be used to process all messages related to device, including telemetry, attribute updates, etc. Otherwise, the root rule chain will be used to process those messages.")
    private RuleChainId defaultRuleChainId;
    @Schema(description="Reference to the dashboard. Used in the mobile application to open the default dashboard when user navigates to device details.")
    private DashboardId defaultDashboardId;
    @NoXss
    @Schema(description="Rule engine queue name. If present, the specified queue will be used to store all unprocessed messages related to device, including telemetry, attribute updates, etc. Otherwise, the 'Main' queue will be used to store those messages.")
    private String defaultQueueName;
    @Valid
    private transient DeviceProfileData profileData;
    @JsonIgnore
    private byte[] profileDataBytes;
    @NoXss
    @Schema(description="Unique provisioning key used by 'Device Provisioning' feature.")
    private String provisionDeviceKey;
    @Schema(description="Reference to the firmware OTA package. If present, the specified package will be used as default device firmware. ")
    private OtaPackageId firmwareId;
    @Schema(description="Reference to the software OTA package. If present, the specified package will be used as default device software. ")
    private OtaPackageId softwareId;
    @Schema(description="Reference to the edge rule chain. If present, the specified edge rule chain will be used on the edge to process all messages related to device, including telemetry, attribute updates, etc. Otherwise, the edge root rule chain will be used to process those messages.")
    private RuleChainId defaultEdgeRuleChainId;
    private DeviceProfileId externalId;
    private Long version;

    public DeviceProfile() {
    }

    public DeviceProfile(DeviceProfileId deviceProfileId) {
        super(deviceProfileId);
    }

    public DeviceProfile(DeviceProfile deviceProfile) {
        super(deviceProfile);
        this.tenantId = deviceProfile.getTenantId();
        this.name = deviceProfile.getName();
        this.description = deviceProfile.getDescription();
        this.image = deviceProfile.getImage();
        this.isDefault = deviceProfile.isDefault();
        this.defaultRuleChainId = deviceProfile.getDefaultRuleChainId();
        this.defaultDashboardId = deviceProfile.getDefaultDashboardId();
        this.defaultQueueName = deviceProfile.getDefaultQueueName();
        this.setProfileData(deviceProfile.getProfileData());
        this.provisionDeviceKey = deviceProfile.getProvisionDeviceKey();
        this.firmwareId = deviceProfile.getFirmwareId();
        this.softwareId = deviceProfile.getSoftwareId();
        this.defaultEdgeRuleChainId = deviceProfile.getDefaultEdgeRuleChainId();
        this.externalId = deviceProfile.getExternalId();
        this.version = deviceProfile.getVersion();
    }

    @Override
    @Schema(description="JSON object with the device profile Id. Specify this field to update the device profile. Referencing non-existing device profile Id will cause error. Omit this field to create new device profile.")
    public DeviceProfileId getId() {
        return (DeviceProfileId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the profile creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Schema(description="Used to mark the default profile. Default profile is used when the device profile is not specified during device creation.")
    public boolean isDefault() {
        return this.isDefault;
    }

    @Schema(description="Complex JSON object that includes addition device profile configuration (transport, alarm rules, etc).")
    public DeviceProfileData getProfileData() {
        if (this.profileData != null) {
            return this.profileData;
        }
        if (this.profileDataBytes != null) {
            try {
                this.profileData = (DeviceProfileData)mapper.readValue((InputStream)new ByteArrayInputStream(this.profileDataBytes), DeviceProfileData.class);
            }
            catch (IOException e) {
                log.warn("Can't deserialize device profile data: ", (Throwable)e);
                return null;
            }
            return this.profileData;
        }
        return null;
    }

    public void setProfileData(DeviceProfileData data) {
        this.profileData = data;
        try {
            this.profileDataBytes = data != null ? mapper.writeValueAsBytes((Object)data) : null;
        }
        catch (JsonProcessingException e) {
            log.warn("Can't serialize device profile data: ", (Throwable)e);
        }
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public DeviceProfileType getType() {
        return this.type;
    }

    @Generated
    public DeviceTransportType getTransportType() {
        return this.transportType;
    }

    @Generated
    public DeviceProfileProvisionType getProvisionType() {
        return this.provisionType;
    }

    @Override
    @Generated
    public RuleChainId getDefaultRuleChainId() {
        return this.defaultRuleChainId;
    }

    @Generated
    public DashboardId getDefaultDashboardId() {
        return this.defaultDashboardId;
    }

    @Override
    @Generated
    public String getDefaultQueueName() {
        return this.defaultQueueName;
    }

    @Generated
    public String getProvisionDeviceKey() {
        return this.provisionDeviceKey;
    }

    @Override
    @Generated
    public OtaPackageId getFirmwareId() {
        return this.firmwareId;
    }

    @Override
    @Generated
    public OtaPackageId getSoftwareId() {
        return this.softwareId;
    }

    @Generated
    public RuleChainId getDefaultEdgeRuleChainId() {
        return this.defaultEdgeRuleChainId;
    }

    @Override
    @Generated
    public DeviceProfileId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Generated
    public void setImage(String image) {
        this.image = image;
    }

    @Generated
    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Generated
    public void setType(DeviceProfileType type) {
        this.type = type;
    }

    @Generated
    public void setTransportType(DeviceTransportType transportType) {
        this.transportType = transportType;
    }

    @Generated
    public void setProvisionType(DeviceProfileProvisionType provisionType) {
        this.provisionType = provisionType;
    }

    @Generated
    public void setDefaultRuleChainId(RuleChainId defaultRuleChainId) {
        this.defaultRuleChainId = defaultRuleChainId;
    }

    @Generated
    public void setDefaultDashboardId(DashboardId defaultDashboardId) {
        this.defaultDashboardId = defaultDashboardId;
    }

    @Generated
    public void setDefaultQueueName(String defaultQueueName) {
        this.defaultQueueName = defaultQueueName;
    }

    @Generated
    public void setProvisionDeviceKey(String provisionDeviceKey) {
        this.provisionDeviceKey = provisionDeviceKey;
    }

    @Override
    @Generated
    public void setFirmwareId(OtaPackageId firmwareId) {
        this.firmwareId = firmwareId;
    }

    @Override
    @Generated
    public void setSoftwareId(OtaPackageId softwareId) {
        this.softwareId = softwareId;
    }

    @Generated
    public void setDefaultEdgeRuleChainId(RuleChainId defaultEdgeRuleChainId) {
        this.defaultEdgeRuleChainId = defaultEdgeRuleChainId;
    }

    @Override
    @Generated
    public void setExternalId(DeviceProfileId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    @Generated
    public String toString() {
        return "DeviceProfile(tenantId=" + String.valueOf(this.getTenantId()) + ", name=" + this.getName() + ", description=" + this.getDescription() + ", isDefault=" + this.isDefault() + ", type=" + String.valueOf((Object)this.getType()) + ", transportType=" + String.valueOf((Object)this.getTransportType()) + ", provisionType=" + String.valueOf((Object)this.getProvisionType()) + ", defaultRuleChainId=" + String.valueOf(this.getDefaultRuleChainId()) + ", defaultDashboardId=" + String.valueOf(this.getDefaultDashboardId()) + ", defaultQueueName=" + this.getDefaultQueueName() + ", profileData=" + String.valueOf(this.getProfileData()) + ", provisionDeviceKey=" + this.getProvisionDeviceKey() + ", firmwareId=" + String.valueOf(this.getFirmwareId()) + ", softwareId=" + String.valueOf(this.getSoftwareId()) + ", defaultEdgeRuleChainId=" + String.valueOf(this.getDefaultEdgeRuleChainId()) + ", externalId=" + String.valueOf(this.getExternalId()) + ", version=" + this.getVersion() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceProfile)) {
            return false;
        }
        DeviceProfile other = (DeviceProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDefault() != other.isDefault()) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        DeviceProfileType this$type = this.getType();
        DeviceProfileType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        DeviceTransportType this$transportType = this.getTransportType();
        DeviceTransportType other$transportType = other.getTransportType();
        if (this$transportType == null ? other$transportType != null : !((Object)((Object)this$transportType)).equals((Object)other$transportType)) {
            return false;
        }
        DeviceProfileProvisionType this$provisionType = this.getProvisionType();
        DeviceProfileProvisionType other$provisionType = other.getProvisionType();
        if (this$provisionType == null ? other$provisionType != null : !((Object)((Object)this$provisionType)).equals((Object)other$provisionType)) {
            return false;
        }
        RuleChainId this$defaultRuleChainId = this.getDefaultRuleChainId();
        RuleChainId other$defaultRuleChainId = other.getDefaultRuleChainId();
        if (this$defaultRuleChainId == null ? other$defaultRuleChainId != null : !((Object)this$defaultRuleChainId).equals(other$defaultRuleChainId)) {
            return false;
        }
        DashboardId this$defaultDashboardId = this.getDefaultDashboardId();
        DashboardId other$defaultDashboardId = other.getDefaultDashboardId();
        if (this$defaultDashboardId == null ? other$defaultDashboardId != null : !((Object)this$defaultDashboardId).equals(other$defaultDashboardId)) {
            return false;
        }
        String this$defaultQueueName = this.getDefaultQueueName();
        String other$defaultQueueName = other.getDefaultQueueName();
        if (this$defaultQueueName == null ? other$defaultQueueName != null : !this$defaultQueueName.equals(other$defaultQueueName)) {
            return false;
        }
        if (!Arrays.equals(this.getProfileDataBytes(), other.getProfileDataBytes())) {
            return false;
        }
        String this$provisionDeviceKey = this.getProvisionDeviceKey();
        String other$provisionDeviceKey = other.getProvisionDeviceKey();
        if (this$provisionDeviceKey == null ? other$provisionDeviceKey != null : !this$provisionDeviceKey.equals(other$provisionDeviceKey)) {
            return false;
        }
        OtaPackageId this$firmwareId = this.getFirmwareId();
        OtaPackageId other$firmwareId = other.getFirmwareId();
        if (this$firmwareId == null ? other$firmwareId != null : !((Object)this$firmwareId).equals(other$firmwareId)) {
            return false;
        }
        OtaPackageId this$softwareId = this.getSoftwareId();
        OtaPackageId other$softwareId = other.getSoftwareId();
        if (this$softwareId == null ? other$softwareId != null : !((Object)this$softwareId).equals(other$softwareId)) {
            return false;
        }
        RuleChainId this$defaultEdgeRuleChainId = this.getDefaultEdgeRuleChainId();
        RuleChainId other$defaultEdgeRuleChainId = other.getDefaultEdgeRuleChainId();
        if (this$defaultEdgeRuleChainId == null ? other$defaultEdgeRuleChainId != null : !((Object)this$defaultEdgeRuleChainId).equals(other$defaultEdgeRuleChainId)) {
            return false;
        }
        DeviceProfileId this$externalId = this.getExternalId();
        DeviceProfileId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeviceProfile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDefault() ? 79 : 97);
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        DeviceProfileType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        DeviceTransportType $transportType = this.getTransportType();
        result = result * 59 + ($transportType == null ? 43 : ((Object)((Object)$transportType)).hashCode());
        DeviceProfileProvisionType $provisionType = this.getProvisionType();
        result = result * 59 + ($provisionType == null ? 43 : ((Object)((Object)$provisionType)).hashCode());
        RuleChainId $defaultRuleChainId = this.getDefaultRuleChainId();
        result = result * 59 + ($defaultRuleChainId == null ? 43 : ((Object)$defaultRuleChainId).hashCode());
        DashboardId $defaultDashboardId = this.getDefaultDashboardId();
        result = result * 59 + ($defaultDashboardId == null ? 43 : ((Object)$defaultDashboardId).hashCode());
        String $defaultQueueName = this.getDefaultQueueName();
        result = result * 59 + ($defaultQueueName == null ? 43 : $defaultQueueName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getProfileDataBytes());
        String $provisionDeviceKey = this.getProvisionDeviceKey();
        result = result * 59 + ($provisionDeviceKey == null ? 43 : $provisionDeviceKey.hashCode());
        OtaPackageId $firmwareId = this.getFirmwareId();
        result = result * 59 + ($firmwareId == null ? 43 : ((Object)$firmwareId).hashCode());
        OtaPackageId $softwareId = this.getSoftwareId();
        result = result * 59 + ($softwareId == null ? 43 : ((Object)$softwareId).hashCode());
        RuleChainId $defaultEdgeRuleChainId = this.getDefaultEdgeRuleChainId();
        result = result * 59 + ($defaultEdgeRuleChainId == null ? 43 : ((Object)$defaultEdgeRuleChainId).hashCode());
        DeviceProfileId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }

    @Generated
    public byte[] getProfileDataBytes() {
        return this.profileDataBytes;
    }

    @JsonIgnore
    @Generated
    public void setProfileDataBytes(byte[] profileDataBytes) {
        this.profileDataBytes = profileDataBytes;
    }
}

