/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import java.io.Serializable;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;

public class DeviceIdInfo
implements Serializable,
HasTenantId {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceIdInfo.class);
    private static final long serialVersionUID = 2233745129677581815L;
    private final TenantId tenantId;
    private final CustomerId customerId;
    private final DeviceId deviceId;

    public DeviceIdInfo(UUID tenantId, UUID customerId, UUID deviceId) {
        this.tenantId = TenantId.fromUUID(tenantId);
        this.customerId = customerId != null ? new CustomerId(customerId) : null;
        this.deviceId = new DeviceId(deviceId);
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceIdInfo)) {
            return false;
        }
        DeviceIdInfo other = (DeviceIdInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        DeviceId this$deviceId = this.getDeviceId();
        DeviceId other$deviceId = other.getDeviceId();
        return !(this$deviceId == null ? other$deviceId != null : !((Object)this$deviceId).equals(other$deviceId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeviceIdInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        DeviceId $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : ((Object)$deviceId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeviceIdInfo(tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", deviceId=" + String.valueOf(this.getDeviceId()) + ")";
    }
}

