/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasLabel;
import org.thingsboard.server.common.data.HasOtaPackage;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.device.data.DeviceData;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class Device
extends BaseDataWithAdditionalInfo<DeviceId>
implements HasLabel,
HasTenantId,
HasCustomerId,
HasOtaPackage,
HasVersion,
ExportableEntity<DeviceId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Device.class);
    private static final long serialVersionUID = 2807343040519543363L;
    private TenantId tenantId;
    private CustomerId customerId;
    @NoXss
    @Length(fieldName="name")
    private String name;
    @NoXss
    @Length(fieldName="type")
    private String type;
    @NoXss
    @Length(fieldName="label")
    private String label;
    private DeviceProfileId deviceProfileId;
    private transient DeviceData deviceData;
    @JsonIgnore
    private byte[] deviceDataBytes;
    private OtaPackageId firmwareId;
    private OtaPackageId softwareId;
    private DeviceId externalId;
    private Long version;

    public Device() {
    }

    public Device(DeviceId id) {
        super(id);
    }

    public Device(Device device) {
        super(device);
        this.tenantId = device.getTenantId();
        this.customerId = device.getCustomerId();
        this.name = device.getName();
        this.type = device.getType();
        this.label = device.getLabel();
        this.deviceProfileId = device.getDeviceProfileId();
        this.setDeviceData(device.getDeviceData());
        this.firmwareId = device.getFirmwareId();
        this.softwareId = device.getSoftwareId();
        this.externalId = device.getExternalId();
        this.version = device.getVersion();
    }

    public Device updateDevice(Device device) {
        this.tenantId = device.getTenantId();
        this.customerId = device.getCustomerId();
        this.name = device.getName();
        this.type = device.getType();
        this.label = device.getLabel();
        this.deviceProfileId = device.getDeviceProfileId();
        this.setDeviceData(device.getDeviceData());
        this.setFirmwareId(device.getFirmwareId());
        this.setSoftwareId(device.getSoftwareId());
        Optional.ofNullable(device.getAdditionalInfo()).ifPresent(this::setAdditionalInfo);
        this.setExternalId(device.getExternalId());
        this.setVersion(device.getVersion());
        return this;
    }

    @Override
    @Schema(description="JSON object with the Device Id. Specify this field to update the Device. Referencing non-existing Device Id will cause error. Omit this field to create new Device.")
    public DeviceId getId() {
        return (DeviceId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the device creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Schema(description="JSON object with Tenant Id. Use 'assignDeviceToTenant' to change the Tenant Id.", accessMode=Schema.AccessMode.READ_ONLY)
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    @Schema(description="JSON object with Customer Id. Use 'assignDeviceToCustomer' to change the Customer Id.", accessMode=Schema.AccessMode.READ_ONLY)
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Override
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Unique Device Name in scope of Tenant", example="A4B72CCDFF33")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="Device Profile Name", example="Temperature Sensor")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    @Schema(description="Label that may be used in widgets", example="Room 234 Sensor")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="JSON object with Device Profile Id.")
    public DeviceProfileId getDeviceProfileId() {
        return this.deviceProfileId;
    }

    public void setDeviceProfileId(DeviceProfileId deviceProfileId) {
        this.deviceProfileId = deviceProfileId;
    }

    @Schema(description="JSON object with content specific to type of transport in the device profile.")
    public DeviceData getDeviceData() {
        if (this.deviceData != null) {
            return this.deviceData;
        }
        if (this.deviceDataBytes != null) {
            try {
                this.deviceData = (DeviceData)mapper.readValue((InputStream)new ByteArrayInputStream(this.deviceDataBytes), DeviceData.class);
            }
            catch (IOException e) {
                log.warn("Can't deserialize device data: ", (Throwable)e);
                return null;
            }
            return this.deviceData;
        }
        return null;
    }

    public void setDeviceData(DeviceData data) {
        this.deviceData = data;
        try {
            this.deviceDataBytes = data != null ? mapper.writeValueAsBytes((Object)data) : null;
        }
        catch (JsonProcessingException e) {
            log.warn("Can't serialize device data: ", (Throwable)e);
        }
    }

    @Override
    @Schema(description="JSON object with Ota Package Id.")
    public OtaPackageId getFirmwareId() {
        return this.firmwareId;
    }

    @Override
    public void setFirmwareId(OtaPackageId firmwareId) {
        this.firmwareId = firmwareId;
    }

    @Override
    @Schema(description="JSON object with Ota Package Id.")
    public OtaPackageId getSoftwareId() {
        return this.softwareId;
    }

    @Override
    public void setSoftwareId(OtaPackageId softwareId) {
        this.softwareId = softwareId;
    }

    @Override
    @Schema(description="Additional parameters of the device", implementation=JsonNode.class)
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Device)) {
            return false;
        }
        Device other = (Device)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        DeviceProfileId this$deviceProfileId = this.getDeviceProfileId();
        DeviceProfileId other$deviceProfileId = other.getDeviceProfileId();
        if (this$deviceProfileId == null ? other$deviceProfileId != null : !((Object)this$deviceProfileId).equals(other$deviceProfileId)) {
            return false;
        }
        if (!Arrays.equals(this.getDeviceDataBytes(), other.getDeviceDataBytes())) {
            return false;
        }
        OtaPackageId this$firmwareId = this.getFirmwareId();
        OtaPackageId other$firmwareId = other.getFirmwareId();
        if (this$firmwareId == null ? other$firmwareId != null : !((Object)this$firmwareId).equals(other$firmwareId)) {
            return false;
        }
        OtaPackageId this$softwareId = this.getSoftwareId();
        OtaPackageId other$softwareId = other.getSoftwareId();
        if (this$softwareId == null ? other$softwareId != null : !((Object)this$softwareId).equals(other$softwareId)) {
            return false;
        }
        DeviceId this$externalId = this.getExternalId();
        DeviceId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Device;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        DeviceProfileId $deviceProfileId = this.getDeviceProfileId();
        result = result * 59 + ($deviceProfileId == null ? 43 : ((Object)$deviceProfileId).hashCode());
        result = result * 59 + Arrays.hashCode(this.getDeviceDataBytes());
        OtaPackageId $firmwareId = this.getFirmwareId();
        result = result * 59 + ($firmwareId == null ? 43 : ((Object)$firmwareId).hashCode());
        OtaPackageId $softwareId = this.getSoftwareId();
        result = result * 59 + ($softwareId == null ? 43 : ((Object)$softwareId).hashCode());
        DeviceId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Device(super=" + super.toString() + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", name=" + this.getName() + ", type=" + this.getType() + ", label=" + this.getLabel() + ", deviceProfileId=" + String.valueOf(this.getDeviceProfileId()) + ", deviceData=" + String.valueOf(this.getDeviceData()) + ", deviceDataBytes=" + Arrays.toString(this.getDeviceDataBytes()) + ", firmwareId=" + String.valueOf(this.getFirmwareId()) + ", softwareId=" + String.valueOf(this.getSoftwareId()) + ", externalId=" + String.valueOf(this.getExternalId()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public byte[] getDeviceDataBytes() {
        return this.deviceDataBytes;
    }

    @JsonIgnore
    @Generated
    public void setDeviceDataBytes(byte[] deviceDataBytes) {
        this.deviceDataBytes = deviceDataBytes;
    }

    @Override
    @Generated
    public DeviceId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public void setExternalId(DeviceId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }
}

