/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.HasImage;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.HasTitle;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.ShortCustomerInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class DashboardInfo
extends BaseData<DashboardId>
implements HasName,
HasTenantId,
HasTitle,
HasImage,
HasVersion {
    private static final long serialVersionUID = -9080404114760433799L;
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="title")
    private String title;
    private String image;
    @Valid
    private Set<ShortCustomerInfo> assignedCustomers;
    private boolean mobileHide;
    private Integer mobileOrder;
    private Long version;

    public DashboardInfo() {
    }

    public DashboardInfo(DashboardId id) {
        super(id);
    }

    public DashboardInfo(DashboardInfo dashboardInfo) {
        super(dashboardInfo);
        this.tenantId = dashboardInfo.getTenantId();
        this.title = dashboardInfo.getTitle();
        this.image = dashboardInfo.getImage();
        this.assignedCustomers = dashboardInfo.getAssignedCustomers();
        this.mobileHide = dashboardInfo.isMobileHide();
        this.mobileOrder = dashboardInfo.getMobileOrder();
        this.version = dashboardInfo.getVersion();
    }

    @Override
    @Schema(description="JSON object with the dashboard Id. Specify existing dashboard Id to update the dashboard. Referencing non-existing dashboard id will cause error. Omit this field to create new dashboard.")
    public DashboardId getId() {
        return (DashboardId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the dashboard creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Schema(description="JSON object with Tenant Id. Tenant Id of the dashboard can't be changed.", accessMode=Schema.AccessMode.READ_ONLY)
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Title of the dashboard.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @Schema(description="Thumbnail picture for rendering of the dashboards in a grid view on mobile devices.", accessMode=Schema.AccessMode.READ_ONLY)
    public String getImage() {
        return this.image;
    }

    @Override
    public void setImage(String image) {
        this.image = image;
    }

    @Schema(description="List of assigned customers with their info.", accessMode=Schema.AccessMode.READ_ONLY)
    public Set<ShortCustomerInfo> getAssignedCustomers() {
        return this.assignedCustomers;
    }

    public void setAssignedCustomers(Set<ShortCustomerInfo> assignedCustomers) {
        this.assignedCustomers = assignedCustomers;
    }

    @Schema(description="Hide dashboard from mobile devices. Useful if the dashboard is not designed for small screens.", accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isMobileHide() {
        return this.mobileHide;
    }

    public void setMobileHide(boolean mobileHide) {
        this.mobileHide = mobileHide;
    }

    @Schema(description="Order on mobile devices. Useful to adjust sorting of the dashboards for mobile applications", accessMode=Schema.AccessMode.READ_ONLY)
    public Integer getMobileOrder() {
        return this.mobileOrder;
    }

    public void setMobileOrder(Integer mobileOrder) {
        this.mobileOrder = mobileOrder;
    }

    public boolean isAssignedToCustomer(CustomerId customerId) {
        return this.assignedCustomers != null && this.assignedCustomers.contains(new ShortCustomerInfo(customerId, null, false));
    }

    public ShortCustomerInfo getAssignedCustomerInfo(CustomerId customerId) {
        if (this.assignedCustomers != null) {
            for (ShortCustomerInfo customerInfo : this.assignedCustomers) {
                if (!customerInfo.getCustomerId().equals(customerId)) continue;
                return customerInfo;
            }
        }
        return null;
    }

    public boolean addAssignedCustomer(Customer customer) {
        ShortCustomerInfo customerInfo = customer.toShortCustomerInfo();
        if (this.assignedCustomers != null && this.assignedCustomers.contains(customerInfo)) {
            return false;
        }
        if (this.assignedCustomers == null) {
            this.assignedCustomers = new HashSet<ShortCustomerInfo>();
        }
        this.assignedCustomers.add(customerInfo);
        return true;
    }

    public boolean updateAssignedCustomer(Customer customer) {
        ShortCustomerInfo customerInfo = customer.toShortCustomerInfo();
        if (this.assignedCustomers != null && this.assignedCustomers.contains(customerInfo)) {
            this.assignedCustomers.remove(customerInfo);
            this.assignedCustomers.add(customerInfo);
            return true;
        }
        return false;
    }

    public boolean removeAssignedCustomer(Customer customer) {
        ShortCustomerInfo customerInfo = customer.toShortCustomerInfo();
        if (this.assignedCustomers != null && this.assignedCustomers.contains(customerInfo)) {
            this.assignedCustomers.remove(customerInfo);
            return true;
        }
        return false;
    }

    @Override
    @Schema(description="Same as title of the dashboard. Read-only field. Update the 'title' to change the 'name' of the dashboard.", accessMode=Schema.AccessMode.READ_ONLY)
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.title;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DashboardInfo that = (DashboardInfo)o;
        return this.mobileHide == that.mobileHide && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.title, that.title) && Objects.equals(this.image, that.image) && Objects.equals(this.assignedCustomers, that.assignedCustomers) && Objects.equals(this.mobileOrder, that.mobileOrder);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DashboardInfo [tenantId=");
        builder.append(this.tenantId);
        builder.append(", title=");
        builder.append(this.title);
        builder.append("]");
        return builder.toString();
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }
}

