/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Streams;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.ResourceExportData;
import org.thingsboard.server.common.data.id.DashboardId;

@JsonPropertyOrder(value={"title", "image", "mobileHide", "mobileOrder", "configuration", "name", "resources"})
public class Dashboard
extends DashboardInfo
implements ExportableEntity<DashboardId> {
    private static final long serialVersionUID = 872682138346187503L;
    private transient JsonNode configuration;
    private DashboardId externalId;
    private List<ResourceExportData> resources;

    public Dashboard() {
    }

    public Dashboard(DashboardId id) {
        super(id);
    }

    public Dashboard(DashboardInfo dashboardInfo) {
        super(dashboardInfo);
    }

    public Dashboard(Dashboard dashboard) {
        super(dashboard);
        this.configuration = dashboard.getConfiguration();
        this.externalId = dashboard.getExternalId();
        this.resources = dashboard.getResources() != null ? new ArrayList<ResourceExportData>(dashboard.getResources()) : null;
    }

    @Schema(description="JSON object with main configuration of the dashboard: layouts, widgets, aliases, etc. The JSON structure of the dashboard configuration is quite complex. The easiest way to learn it is to export existing dashboard to JSON.", implementation=JsonNode.class)
    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    @JsonIgnore
    public List<ObjectNode> getEntityAliasesConfig() {
        return this.getChildObjects("entityAliases");
    }

    @JsonIgnore
    public List<ObjectNode> getWidgetsConfig() {
        return this.getChildObjects("widgets");
    }

    @JsonIgnore
    private List<ObjectNode> getChildObjects(String propertyName) {
        return Optional.ofNullable(this.configuration).map(config -> config.get(propertyName)).filter(node -> !node.isEmpty() && (node.isObject() || node.isArray())).map(node -> Streams.stream((Iterator)node.elements()).filter(JsonNode::isObject).map(jsonNode -> (ObjectNode)jsonNode).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Dashboard [tenantId=");
        builder.append(this.getTenantId());
        builder.append(", title=");
        builder.append(this.getTitle());
        builder.append(", configuration=");
        builder.append(this.configuration);
        builder.append("]");
        return builder.toString();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dashboard)) {
            return false;
        }
        Dashboard other = (Dashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DashboardId this$externalId = this.getExternalId();
        DashboardId other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId)) {
            return false;
        }
        List<ResourceExportData> this$resources = this.getResources();
        List<ResourceExportData> other$resources = other.getResources();
        return !(this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Dashboard;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DashboardId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        List<ResourceExportData> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        return result;
    }

    @Override
    @Generated
    public DashboardId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public void setExternalId(DashboardId externalId) {
        this.externalId = externalId;
    }

    @Generated
    public List<ResourceExportData> getResources() {
        return this.resources;
    }

    @Generated
    public void setResources(List<ResourceExportData> resources) {
        this.resources = resources;
    }
}

