/**
 * Copyright © 2016-2025 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.thingsboard.server.common.data.ai.dto;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        property = "status",
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = TbChatResponse.Success.class, name = "SUCCESS"),
        @JsonSubTypes.Type(value = TbChatResponse.Failure.class, name = "FAILURE")
})
public sealed interface TbChatResponse permits TbChatResponse.Success, TbChatResponse.Failure {

    @Schema(
            description = "Indicates whether the request was successful or not",
            example = "SUCCESS"
    )
    String getStatus();

    record Success(
            @Schema(description = "The text content generated by the model")
            String generatedContent
    ) implements TbChatResponse {

        @Override
        @Schema(example = "SUCCESS")
        public String getStatus() {
            return "SUCCESS";
        }

    }

    record Failure(
            @Schema(description = "A string containing details about the failure")
            String errorDetails
    ) implements TbChatResponse {

        @Override
        @Schema(example = "FAILURE")
        public String getStatus() {
            return "FAILURE";
        }

    }

}
