/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.wl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.Arrays;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;
import org.thingsboard.server.common.data.wl.WhiteLabelingType;

public class WhiteLabeling
implements Serializable {
    private static final long serialVersionUID = 2628323657987010348L;
    private EntityId entityId;
    @NoXss
    @Length(fieldName="type", max=50)
    private WhiteLabelingType type;
    @NoXss
    @Length(fieldName="settings", max=10000000)
    private transient JsonNode settings;
    @NoXss
    @Length(fieldName="domain")
    private String domain;
    @JsonIgnore
    private byte[] settingsBytes;

    public JsonNode getSettings() {
        return BaseDataWithAdditionalInfo.getJson(() -> this.settings, () -> this.settingsBytes);
    }

    public void setSettings(JsonNode settings) {
        BaseDataWithAdditionalInfo.setJson(settings, json -> {
            this.settings = json;
        }, bytes -> {
            this.settingsBytes = bytes;
        });
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public WhiteLabelingType getType() {
        return this.type;
    }

    public String getDomain() {
        return this.domain;
    }

    public byte[] getSettingsBytes() {
        return this.settingsBytes;
    }

    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    public void setType(WhiteLabelingType type) {
        this.type = type;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonIgnore
    public void setSettingsBytes(byte[] settingsBytes) {
        this.settingsBytes = settingsBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhiteLabeling)) {
            return false;
        }
        WhiteLabeling other = (WhiteLabeling)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        WhiteLabelingType this$type = this.getType();
        WhiteLabelingType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        return Arrays.equals(this.getSettingsBytes(), other.getSettingsBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof WhiteLabeling;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        WhiteLabelingType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSettingsBytes());
        return result;
    }

    public String toString() {
        return "WhiteLabeling(entityId=" + this.getEntityId() + ", type=" + this.getType() + ", settings=" + this.getSettings() + ", domain=" + this.getDomain() + ", settingsBytes=" + Arrays.toString(this.getSettingsBytes()) + ")";
    }
}

