/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.widget;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasTitle;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class WidgetsBundle
extends BaseData<WidgetsBundleId>
implements TenantEntity,
ExportableEntity<WidgetsBundleId>,
HasTitle {
    private static final long serialVersionUID = -7627368878362410489L;
    @ApiModelProperty(position=3, value="JSON object with Tenant Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="alias")
    @ApiModelProperty(position=4, value="Unique alias that is used in widget types as a reference widget bundle", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String alias;
    @NoXss
    @Length(fieldName="title")
    @ApiModelProperty(position=5, value="Title used in search and UI", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String title;
    @Length(fieldName="image", max=1000000)
    @ApiModelProperty(position=6, value="Base64 encoded thumbnail", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String image;
    @NoXss
    @Length(fieldName="description", max=1024)
    @ApiModelProperty(position=7, value="Description", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String description;
    private WidgetsBundleId externalId;

    public WidgetsBundle() {
    }

    public WidgetsBundle(WidgetsBundleId id) {
        super(id);
    }

    public WidgetsBundle(WidgetsBundle widgetsBundle) {
        super(widgetsBundle);
        this.tenantId = widgetsBundle.getTenantId();
        this.alias = widgetsBundle.getAlias();
        this.title = widgetsBundle.getTitle();
        this.image = widgetsBundle.getImage();
        this.description = widgetsBundle.getDescription();
        this.externalId = widgetsBundle.getExternalId();
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the Widget Bundle Id. Specify this field to update the Widget Bundle. Referencing non-existing Widget Bundle Id will cause error. Omit this field to create new Widget Bundle.")
    public WidgetsBundleId getId() {
        return (WidgetsBundleId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the Widget Bundle creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @ApiModelProperty(position=3, value="Same as title of the Widget Bundle. Read-only field. Update the 'title' to change the 'name' of the Widget Bundle.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.title;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WidgetsBundle{");
        sb.append("tenantId=").append(this.tenantId);
        sb.append(", alias='").append(this.alias).append('\'');
        sb.append(", title='").append(this.title).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.WIDGETS_BUNDLE;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WidgetsBundle)) {
            return false;
        }
        WidgetsBundle other = (WidgetsBundle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        WidgetsBundleId this$externalId = this.getExternalId();
        WidgetsBundleId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WidgetsBundle;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        WidgetsBundleId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public WidgetsBundleId getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(WidgetsBundleId externalId) {
        this.externalId = externalId;
    }
}

