/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.widget;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;
import org.thingsboard.server.common.data.widget.BaseWidgetType;
import org.thingsboard.server.common.data.widget.WidgetType;

@JsonPropertyOrder(value={"fqn", "name", "deprecated", "image", "description", "descriptor", "externalId"})
public class WidgetTypeDetails
extends WidgetType
implements HasName,
HasTenantId,
ExportableEntity<WidgetTypeId> {
    @Length(fieldName="image", max=1000000)
    @ApiModelProperty(position=9, value="Base64 encoded thumbnail")
    private String image;
    @NoXss
    @Length(fieldName="description", max=1024)
    @ApiModelProperty(position=10, value="Description of the widget")
    private String description;
    private WidgetTypeId externalId;

    public WidgetTypeDetails() {
    }

    public WidgetTypeDetails(WidgetTypeId id) {
        super(id);
    }

    public WidgetTypeDetails(BaseWidgetType baseWidgetType) {
        super(baseWidgetType);
    }

    public WidgetTypeDetails(WidgetTypeDetails widgetTypeDetails) {
        super(widgetTypeDetails);
        this.image = widgetTypeDetails.getImage();
        this.description = widgetTypeDetails.getDescription();
        this.externalId = widgetTypeDetails.getExternalId();
    }

    public String getImage() {
        return this.image;
    }

    public String getDescription() {
        return this.description;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WidgetTypeDetails)) {
            return false;
        }
        WidgetTypeDetails other = (WidgetTypeDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        WidgetTypeId this$externalId = this.getExternalId();
        WidgetTypeId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WidgetTypeDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        WidgetTypeId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WidgetTypeDetails(image=" + this.getImage() + ", description=" + this.getDescription() + ", externalId=" + this.getExternalId() + ")";
    }

    @Override
    public WidgetTypeId getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(WidgetTypeId externalId) {
        this.externalId = externalId;
    }
}

