/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.sync.vc;

import java.io.Serializable;
import org.thingsboard.server.common.data.sync.vc.EntityVersion;

public class VersionCreationResult
implements Serializable {
    private static final long serialVersionUID = 8032189124530267838L;
    private EntityVersion version;
    private int added;
    private int modified;
    private int removed;
    private String error;
    private boolean done;

    public VersionCreationResult(EntityVersion version, int added, int modified, int removed) {
        this.version = version;
        this.added = added;
        this.modified = modified;
        this.removed = removed;
        this.done = true;
    }

    public VersionCreationResult(String error) {
        this.error = error;
        this.done = true;
    }

    public EntityVersion getVersion() {
        return this.version;
    }

    public int getAdded() {
        return this.added;
    }

    public int getModified() {
        return this.modified;
    }

    public int getRemoved() {
        return this.removed;
    }

    public String getError() {
        return this.error;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setVersion(EntityVersion version) {
        this.version = version;
    }

    public void setAdded(int added) {
        this.added = added;
    }

    public void setModified(int modified) {
        this.modified = modified;
    }

    public void setRemoved(int removed) {
        this.removed = removed;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionCreationResult)) {
            return false;
        }
        VersionCreationResult other = (VersionCreationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAdded() != other.getAdded()) {
            return false;
        }
        if (this.getModified() != other.getModified()) {
            return false;
        }
        if (this.getRemoved() != other.getRemoved()) {
            return false;
        }
        if (this.isDone() != other.isDone()) {
            return false;
        }
        EntityVersion this$version = this.getVersion();
        EntityVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VersionCreationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAdded();
        result = result * 59 + this.getModified();
        result = result * 59 + this.getRemoved();
        result = result * 59 + (this.isDone() ? 79 : 97);
        EntityVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    public String toString() {
        return "VersionCreationResult(version=" + this.getVersion() + ", added=" + this.getAdded() + ", modified=" + this.getModified() + ", removed=" + this.getRemoved() + ", error=" + this.getError() + ", done=" + this.isDone() + ")";
    }

    public VersionCreationResult() {
    }
}

