/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.sync.vc;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import org.apache.commons.lang3.ClassUtils;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.EntityId;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EntityLoadError
implements Serializable {
    private static final long serialVersionUID = 7538450180582109391L;
    private String type;
    private EntityId source;
    private EntityId target;
    private String message;

    public static EntityLoadError credentialsError(EntityId sourceId) {
        return EntityLoadError.builder().type("DEVICE_CREDENTIALS_CONFLICT").source(sourceId).build();
    }

    public static EntityLoadError routingKeyError(EntityId sourceId) {
        return EntityLoadError.builder().type("INTEGRATION_ROUTING_KEY_CONFLICT").source(sourceId).build();
    }

    public static EntityLoadError referenceEntityError(EntityId sourceId, EntityId targetId) {
        return EntityLoadError.builder().type("MISSING_REFERENCED_ENTITY").source(sourceId).target(targetId).build();
    }

    public static EntityLoadError runtimeError(Throwable e) {
        Object message = e.getMessage();
        if (StringUtils.isEmpty((String)message)) {
            message = "unexpected error (" + ClassUtils.getShortClassName(e.getClass()) + ")";
        }
        return EntityLoadError.builder().type("RUNTIME").message((String)message).build();
    }

    @ConstructorProperties(value={"type", "source", "target", "message"})
    EntityLoadError(String type, EntityId source, EntityId target, String message) {
        this.type = type;
        this.source = source;
        this.target = target;
        this.message = message;
    }

    public static EntityLoadErrorBuilder builder() {
        return new EntityLoadErrorBuilder();
    }

    public String getType() {
        return this.type;
    }

    public EntityId getSource() {
        return this.source;
    }

    public EntityId getTarget() {
        return this.target;
    }

    public String getMessage() {
        return this.message;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSource(EntityId source) {
        this.source = source;
    }

    public void setTarget(EntityId target) {
        this.target = target;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityLoadError)) {
            return false;
        }
        EntityLoadError other = (EntityLoadError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        EntityId this$source = this.getSource();
        EntityId other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        EntityId this$target = this.getTarget();
        EntityId other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityLoadError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        EntityId $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        EntityId $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "EntityLoadError(type=" + this.getType() + ", source=" + this.getSource() + ", target=" + this.getTarget() + ", message=" + this.getMessage() + ")";
    }

    public static class EntityLoadErrorBuilder {
        private String type;
        private EntityId source;
        private EntityId target;
        private String message;

        EntityLoadErrorBuilder() {
        }

        public EntityLoadErrorBuilder type(String type) {
            this.type = type;
            return this;
        }

        public EntityLoadErrorBuilder source(EntityId source) {
            this.source = source;
            return this;
        }

        public EntityLoadErrorBuilder target(EntityId target) {
            this.target = target;
            return this;
        }

        public EntityLoadErrorBuilder message(String message) {
            this.message = message;
            return this;
        }

        public EntityLoadError build() {
            return new EntityLoadError(this.type, this.source, this.target, this.message);
        }

        public String toString() {
            return "EntityLoadError.EntityLoadErrorBuilder(type=" + this.type + ", source=" + this.source + ", target=" + this.target + ", message=" + this.message + ")";
        }
    }
}

