/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.sync.ie;

import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.util.ThrowingRunnable;

public class EntityImportResult<E extends ExportableEntity<? extends EntityId>> {
    private E savedEntity;
    private E oldEntity;
    private EntityType entityType;
    private ThrowingRunnable saveReferencesCallback = () -> {};
    private ThrowingRunnable sendEventsCallback = () -> {};
    private boolean updatedAllExternalIds = true;
    private boolean created;
    private boolean updated;
    private boolean updatedRelatedEntities;

    public void addSaveReferencesCallback(ThrowingRunnable callback) {
        this.saveReferencesCallback = this.saveReferencesCallback.andThen(callback);
    }

    public void addSendEventsCallback(ThrowingRunnable callback) {
        this.sendEventsCallback = this.sendEventsCallback.andThen(callback);
    }

    public E getSavedEntity() {
        return this.savedEntity;
    }

    public E getOldEntity() {
        return this.oldEntity;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public ThrowingRunnable getSaveReferencesCallback() {
        return this.saveReferencesCallback;
    }

    public ThrowingRunnable getSendEventsCallback() {
        return this.sendEventsCallback;
    }

    public boolean isUpdatedAllExternalIds() {
        return this.updatedAllExternalIds;
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean isUpdatedRelatedEntities() {
        return this.updatedRelatedEntities;
    }

    public void setSavedEntity(E savedEntity) {
        this.savedEntity = savedEntity;
    }

    public void setOldEntity(E oldEntity) {
        this.oldEntity = oldEntity;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public void setSaveReferencesCallback(ThrowingRunnable saveReferencesCallback) {
        this.saveReferencesCallback = saveReferencesCallback;
    }

    public void setSendEventsCallback(ThrowingRunnable sendEventsCallback) {
        this.sendEventsCallback = sendEventsCallback;
    }

    public void setUpdatedAllExternalIds(boolean updatedAllExternalIds) {
        this.updatedAllExternalIds = updatedAllExternalIds;
    }

    public void setCreated(boolean created) {
        this.created = created;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public void setUpdatedRelatedEntities(boolean updatedRelatedEntities) {
        this.updatedRelatedEntities = updatedRelatedEntities;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityImportResult)) {
            return false;
        }
        EntityImportResult other = (EntityImportResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUpdatedAllExternalIds() != other.isUpdatedAllExternalIds()) {
            return false;
        }
        if (this.isCreated() != other.isCreated()) {
            return false;
        }
        if (this.isUpdated() != other.isUpdated()) {
            return false;
        }
        if (this.isUpdatedRelatedEntities() != other.isUpdatedRelatedEntities()) {
            return false;
        }
        E this$savedEntity = this.getSavedEntity();
        E other$savedEntity = other.getSavedEntity();
        if (this$savedEntity == null ? other$savedEntity != null : !this$savedEntity.equals(other$savedEntity)) {
            return false;
        }
        E this$oldEntity = this.getOldEntity();
        E other$oldEntity = other.getOldEntity();
        if (this$oldEntity == null ? other$oldEntity != null : !this$oldEntity.equals(other$oldEntity)) {
            return false;
        }
        EntityType this$entityType = this.getEntityType();
        EntityType other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !((Object)((Object)this$entityType)).equals((Object)other$entityType)) {
            return false;
        }
        ThrowingRunnable this$saveReferencesCallback = this.getSaveReferencesCallback();
        ThrowingRunnable other$saveReferencesCallback = other.getSaveReferencesCallback();
        if (this$saveReferencesCallback == null ? other$saveReferencesCallback != null : !this$saveReferencesCallback.equals(other$saveReferencesCallback)) {
            return false;
        }
        ThrowingRunnable this$sendEventsCallback = this.getSendEventsCallback();
        ThrowingRunnable other$sendEventsCallback = other.getSendEventsCallback();
        return !(this$sendEventsCallback == null ? other$sendEventsCallback != null : !this$sendEventsCallback.equals(other$sendEventsCallback));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityImportResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUpdatedAllExternalIds() ? 79 : 97);
        result = result * 59 + (this.isCreated() ? 79 : 97);
        result = result * 59 + (this.isUpdated() ? 79 : 97);
        result = result * 59 + (this.isUpdatedRelatedEntities() ? 79 : 97);
        E $savedEntity = this.getSavedEntity();
        result = result * 59 + ($savedEntity == null ? 43 : $savedEntity.hashCode());
        E $oldEntity = this.getOldEntity();
        result = result * 59 + ($oldEntity == null ? 43 : $oldEntity.hashCode());
        EntityType $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : ((Object)((Object)$entityType)).hashCode());
        ThrowingRunnable $saveReferencesCallback = this.getSaveReferencesCallback();
        result = result * 59 + ($saveReferencesCallback == null ? 43 : $saveReferencesCallback.hashCode());
        ThrowingRunnable $sendEventsCallback = this.getSendEventsCallback();
        result = result * 59 + ($sendEventsCallback == null ? 43 : $sendEventsCallback.hashCode());
        return result;
    }

    public String toString() {
        return "EntityImportResult(savedEntity=" + this.getSavedEntity() + ", oldEntity=" + this.getOldEntity() + ", entityType=" + this.getEntityType() + ", saveReferencesCallback=" + this.getSaveReferencesCallback() + ", sendEventsCallback=" + this.getSendEventsCallback() + ", updatedAllExternalIds=" + this.isUpdatedAllExternalIds() + ", created=" + this.isCreated() + ", updated=" + this.isUpdated() + ", updatedRelatedEntities=" + this.isUpdatedRelatedEntities() + ")";
    }
}

