/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.sync.ie;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.sync.JsonTbEntity;
import org.thingsboard.server.common.data.sync.ie.AttributeExportData;
import org.thingsboard.server.common.data.sync.ie.DeviceExportData;
import org.thingsboard.server.common.data.sync.ie.EntityGroupExportData;
import org.thingsboard.server.common.data.sync.ie.GroupEntityExportData;
import org.thingsboard.server.common.data.sync.ie.RuleChainExportData;
import org.thingsboard.server.common.data.sync.ie.WidgetTypeExportData;
import org.thingsboard.server.common.data.sync.ie.WidgetsBundleExportData;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="entityType", include=JsonTypeInfo.As.EXISTING_PROPERTY, visible=true, defaultImpl=EntityExportData.class)
@JsonSubTypes(value={@JsonSubTypes.Type(name="DEVICE", value=DeviceExportData.class), @JsonSubTypes.Type(name="RULE_CHAIN", value=RuleChainExportData.class), @JsonSubTypes.Type(name="WIDGET_TYPE", value=WidgetTypeExportData.class), @JsonSubTypes.Type(name="WIDGETS_BUNDLE", value=WidgetsBundleExportData.class), @JsonSubTypes.Type(name="ENTITY_GROUP", value=EntityGroupExportData.class), @JsonSubTypes.Type(name="ASSET", value=GroupEntityExportData.class), @JsonSubTypes.Type(name="DASHBOARD", value=GroupEntityExportData.class), @JsonSubTypes.Type(name="CUSTOMER", value=GroupEntityExportData.class), @JsonSubTypes.Type(name="ENTITY_VIEW", value=GroupEntityExportData.class)})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EntityExportData<E extends ExportableEntity<? extends EntityId>> {
    public static final Comparator<EntityRelation> relationsComparator = Comparator.comparing(EntityRelation::getFrom, Comparator.comparing(EntityId::getId)).thenComparing(EntityRelation::getTo, Comparator.comparing(EntityId::getId)).thenComparing(EntityRelation::getTypeGroup).thenComparing(EntityRelation::getType);
    public static final Comparator<AttributeExportData> attrComparator = Comparator.comparing(AttributeExportData::getKey).thenComparing(AttributeExportData::getLastUpdateTs);
    @JsonProperty(index=2)
    @JsonTbEntity
    private E entity;
    @JsonProperty(index=1)
    private EntityType entityType;
    @JsonProperty(index=100)
    private List<EntityRelation> relations;
    @JsonProperty(index=101)
    private Map<String, List<AttributeExportData>> attributes;

    public EntityExportData<E> sort() {
        if (this.relations != null && !this.relations.isEmpty()) {
            this.relations.sort(relationsComparator);
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            this.attributes.values().forEach(list -> list.sort(attrComparator));
        }
        return this;
    }

    @JsonIgnore
    public EntityId getExternalId() {
        return this.entity.getExternalId() != null ? this.entity.getExternalId() : (EntityId)this.entity.getId();
    }

    @JsonIgnore
    public boolean hasCredentials() {
        return false;
    }

    @JsonIgnore
    public boolean hasAttributes() {
        return this.attributes != null;
    }

    @JsonIgnore
    public boolean hasRelations() {
        return this.relations != null;
    }

    @JsonIgnore
    public boolean hasPermissions() {
        return false;
    }

    @JsonIgnore
    public boolean hasGroupEntities() {
        return false;
    }

    public E getEntity() {
        return this.entity;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public List<EntityRelation> getRelations() {
        return this.relations;
    }

    public Map<String, List<AttributeExportData>> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(index=2)
    public void setEntity(E entity) {
        this.entity = entity;
    }

    @JsonProperty(index=1)
    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    @JsonProperty(index=100)
    public void setRelations(List<EntityRelation> relations) {
        this.relations = relations;
    }

    @JsonProperty(index=101)
    public void setAttributes(Map<String, List<AttributeExportData>> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityExportData)) {
            return false;
        }
        EntityExportData other = (EntityExportData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        E this$entity = this.getEntity();
        E other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        EntityType this$entityType = this.getEntityType();
        EntityType other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !((Object)((Object)this$entityType)).equals((Object)other$entityType)) {
            return false;
        }
        List<EntityRelation> this$relations = this.getRelations();
        List<EntityRelation> other$relations = other.getRelations();
        if (this$relations == null ? other$relations != null : !((Object)this$relations).equals(other$relations)) {
            return false;
        }
        Map<String, List<AttributeExportData>> this$attributes = this.getAttributes();
        Map<String, List<AttributeExportData>> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityExportData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        E $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        EntityType $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : ((Object)((Object)$entityType)).hashCode());
        List<EntityRelation> $relations = this.getRelations();
        result = result * 59 + ($relations == null ? 43 : ((Object)$relations).hashCode());
        Map<String, List<AttributeExportData>> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "EntityExportData(entity=" + this.getEntity() + ", entityType=" + this.getEntityType() + ", relations=" + this.getRelations() + ", attributes=" + this.getAttributes() + ")";
    }
}

