/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.settings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.settings.UserSettingsType;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class UserSettings
implements Serializable {
    private static final long serialVersionUID = 2628320657987010348L;
    @ApiModelProperty(position=1, value="JSON object with User id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private UserId userId;
    @ApiModelProperty(position=2, value="Type of the settings.")
    @NoXss
    @Length(fieldName="type", max=50)
    private UserSettingsType type;
    @ApiModelProperty(position=3, value="JSON object with user settings.", dataType="com.fasterxml.jackson.databind.JsonNode")
    @NoXss
    @Length(fieldName="settings", max=100000)
    private transient JsonNode settings;
    @JsonIgnore
    private byte[] settingsBytes;

    public JsonNode getSettings() {
        return BaseDataWithAdditionalInfo.getJson(() -> this.settings, () -> this.settingsBytes);
    }

    public void setSettings(JsonNode settings) {
        BaseDataWithAdditionalInfo.setJson(settings, json -> {
            this.settings = json;
        }, bytes -> {
            this.settingsBytes = bytes;
        });
    }

    public UserId getUserId() {
        return this.userId;
    }

    public UserSettingsType getType() {
        return this.type;
    }

    public byte[] getSettingsBytes() {
        return this.settingsBytes;
    }

    public void setUserId(UserId userId) {
        this.userId = userId;
    }

    public void setType(UserSettingsType type) {
        this.type = type;
    }

    @JsonIgnore
    public void setSettingsBytes(byte[] settingsBytes) {
        this.settingsBytes = settingsBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserSettings)) {
            return false;
        }
        UserSettings other = (UserSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UserId this$userId = this.getUserId();
        UserId other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        UserSettingsType this$type = this.getType();
        UserSettingsType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        return Arrays.equals(this.getSettingsBytes(), other.getSettingsBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserId $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        UserSettingsType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getSettingsBytes());
        return result;
    }

    public String toString() {
        return "UserSettings(userId=" + this.getUserId() + ", type=" + this.getType() + ", settings=" + this.getSettings() + ", settingsBytes=" + Arrays.toString(this.getSettingsBytes()) + ")";
    }
}

