/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.security.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.security.Authority;

@ApiModel(value="JWT Pair")
public class JwtPair {
    @ApiModelProperty(position=1, value="The JWT Access Token. Used to perform API calls.", example="AAB254FF67D..")
    private String token;
    @ApiModelProperty(position=1, value="The JWT Refresh Token. Used to get new JWT Access Token if old one has expired.", example="AAB254FF67D..")
    private String refreshToken;
    private Authority scope;

    public JwtPair(String token, String refreshToken) {
        this.token = token;
        this.refreshToken = refreshToken;
    }

    public String getToken() {
        return this.token;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Authority getScope() {
        return this.scope;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setScope(Authority scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtPair)) {
            return false;
        }
        JwtPair other = (JwtPair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        Authority this$scope = this.getScope();
        Authority other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtPair;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        Authority $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
        return result;
    }

    public String toString() {
        return "JwtPair(token=" + this.getToken() + ", refreshToken=" + this.getRefreshToken() + ", scope=" + this.getScope() + ")";
    }

    public JwtPair() {
    }
}

