/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Calendar;
import java.util.List;
import org.thingsboard.server.common.data.scheduler.SchedulerRepeat;
import org.thingsboard.server.common.data.scheduler.SchedulerRepeatType;
import org.thingsboard.server.common.data.scheduler.SchedulerUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WeeklyRepeat
implements SchedulerRepeat {
    private long endsOn;
    private List<Integer> repeatOn;

    @Override
    public SchedulerRepeatType getType() {
        return SchedulerRepeatType.WEEKLY;
    }

    @Override
    public long getNext(long startTime, long ts, String timezone) {
        Calendar calendar = SchedulerUtils.getCalendarWithTimeZone(timezone);
        long tmp = startTime;
        calendar.setTimeInMillis(tmp);
        while (tmp < this.endsOn) {
            if (tmp > ts) {
                int dayOfWeek = calendar.get(7);
                if (this.repeatOn.contains(--dayOfWeek)) {
                    return tmp;
                }
            }
            calendar.add(6, 1);
            tmp = calendar.getTimeInMillis();
        }
        return 0L;
    }

    @Override
    public long getEndsOn() {
        return this.endsOn;
    }

    public List<Integer> getRepeatOn() {
        return this.repeatOn;
    }

    public void setEndsOn(long endsOn) {
        this.endsOn = endsOn;
    }

    public void setRepeatOn(List<Integer> repeatOn) {
        this.repeatOn = repeatOn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeeklyRepeat)) {
            return false;
        }
        WeeklyRepeat other = (WeeklyRepeat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEndsOn() != other.getEndsOn()) {
            return false;
        }
        List<Integer> this$repeatOn = this.getRepeatOn();
        List<Integer> other$repeatOn = other.getRepeatOn();
        return !(this$repeatOn == null ? other$repeatOn != null : !((Object)this$repeatOn).equals(other$repeatOn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeeklyRepeat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $endsOn = this.getEndsOn();
        result = result * 59 + (int)($endsOn >>> 32 ^ $endsOn);
        List<Integer> $repeatOn = this.getRepeatOn();
        result = result * 59 + ($repeatOn == null ? 43 : ((Object)$repeatOn).hashCode());
        return result;
    }

    public String toString() {
        return "WeeklyRepeat(endsOn=" + this.getEndsOn() + ", repeatOn=" + this.getRepeatOn() + ")";
    }
}

