/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.concurrent.TimeUnit;
import org.thingsboard.server.common.data.scheduler.SchedulerRepeat;
import org.thingsboard.server.common.data.scheduler.SchedulerRepeatType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TimerRepeat
implements SchedulerRepeat {
    private long repeatInterval;
    private TimeUnit timeUnit;
    private long endsOn;

    @Override
    public long getEndsOn() {
        return this.endsOn;
    }

    @Override
    public SchedulerRepeatType getType() {
        return SchedulerRepeatType.TIMER;
    }

    @Override
    public long getNext(long startTime, long ts, String timezone) {
        long interval = this.timeUnit.toMillis(this.repeatInterval);
        for (long tmp = startTime; tmp < this.endsOn; tmp += interval) {
            if (tmp <= ts) continue;
            return tmp;
        }
        return 0L;
    }

    public long getRepeatInterval() {
        return this.repeatInterval;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setRepeatInterval(long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setEndsOn(long endsOn) {
        this.endsOn = endsOn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimerRepeat)) {
            return false;
        }
        TimerRepeat other = (TimerRepeat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRepeatInterval() != other.getRepeatInterval()) {
            return false;
        }
        if (this.getEndsOn() != other.getEndsOn()) {
            return false;
        }
        TimeUnit this$timeUnit = this.getTimeUnit();
        TimeUnit other$timeUnit = other.getTimeUnit();
        return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimerRepeat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $repeatInterval = this.getRepeatInterval();
        result = result * 59 + (int)($repeatInterval >>> 32 ^ $repeatInterval);
        long $endsOn = this.getEndsOn();
        result = result * 59 + (int)($endsOn >>> 32 ^ $endsOn);
        TimeUnit $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        return result;
    }

    public String toString() {
        return "TimerRepeat(repeatInterval=" + this.getRepeatInterval() + ", timeUnit=" + this.getTimeUnit() + ", endsOn=" + this.getEndsOn() + ")";
    }
}

