/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Calendar;
import org.thingsboard.server.common.data.scheduler.SchedulerRepeat;
import org.thingsboard.server.common.data.scheduler.SchedulerRepeatType;
import org.thingsboard.server.common.data.scheduler.SchedulerUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EveryNWeeksRepeat
implements SchedulerRepeat {
    private long endsOn;
    private int weeks;

    @Override
    public SchedulerRepeatType getType() {
        return SchedulerRepeatType.EVERY_N_WEEKS;
    }

    @Override
    public long getNext(long startTime, long ts, String timezone) {
        Calendar calendar = SchedulerUtils.getCalendarWithTimeZone(timezone);
        long tmp = startTime;
        int repeatIteration = 0;
        while (tmp < this.endsOn) {
            calendar.setTimeInMillis(startTime);
            calendar.add(6, repeatIteration * this.weeks * 7);
            tmp = calendar.getTimeInMillis();
            if (tmp > ts && tmp < this.endsOn) {
                return tmp;
            }
            ++repeatIteration;
        }
        return 0L;
    }

    @Override
    public long getEndsOn() {
        return this.endsOn;
    }

    public int getWeeks() {
        return this.weeks;
    }

    public void setEndsOn(long endsOn) {
        this.endsOn = endsOn;
    }

    public void setWeeks(int weeks) {
        this.weeks = weeks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EveryNWeeksRepeat)) {
            return false;
        }
        EveryNWeeksRepeat other = (EveryNWeeksRepeat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEndsOn() != other.getEndsOn()) {
            return false;
        }
        return this.getWeeks() == other.getWeeks();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EveryNWeeksRepeat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $endsOn = this.getEndsOn();
        result = result * 59 + (int)($endsOn >>> 32 ^ $endsOn);
        result = result * 59 + this.getWeeks();
        return result;
    }

    public String toString() {
        return "EveryNWeeksRepeat(endsOn=" + this.getEndsOn() + ", weeks=" + this.getWeeks() + ")";
    }
}

