/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.rule;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class RuleChain
extends BaseDataWithAdditionalInfo<RuleChainId>
implements HasName,
TenantEntity,
ExportableEntity<RuleChainId> {
    private static final Logger log = LoggerFactory.getLogger(RuleChain.class);
    private static final long serialVersionUID = -5656679015121935465L;
    @ApiModelProperty(position=3, required=true, value="JSON object with Tenant Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="name")
    @ApiModelProperty(position=4, required=true, value="Rule Chain name", example="Humidity data processing")
    private String name;
    @ApiModelProperty(position=5, value="Rule Chain type. 'EDGE' rule chains are processing messages on the edge devices only.", example="A4B72CCDFF33")
    private RuleChainType type;
    @ApiModelProperty(position=6, value="JSON object with Rule Chain Id. Pointer to the first rule node that should receive all messages pushed to this rule chain.")
    private RuleNodeId firstRuleNodeId;
    @ApiModelProperty(position=7, value="Indicates root rule chain. The root rule chain process messages from all devices and entities by default. User may configure default rule chain per device profile.")
    private boolean root;
    @ApiModelProperty(position=8, value="Reserved for future usage.")
    private boolean debugMode;
    @ApiModelProperty(position=9, value="Reserved for future usage. The actual list of rule nodes and their relations is stored in the database separately.")
    private transient JsonNode configuration;
    private RuleChainId externalId;
    @JsonIgnore
    private byte[] configurationBytes;

    public RuleChain() {
    }

    public RuleChain(RuleChainId id) {
        super(id);
    }

    public RuleChain(RuleChain ruleChain) {
        super(ruleChain);
        this.tenantId = ruleChain.getTenantId();
        this.name = ruleChain.getName();
        this.type = ruleChain.getType();
        this.firstRuleNodeId = ruleChain.getFirstRuleNodeId();
        this.root = ruleChain.isRoot();
        this.setConfiguration(ruleChain.getConfiguration());
        this.setExternalId(ruleChain.getExternalId());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the Rule Chain Id. Specify this field to update the Rule Chain. Referencing non-existing Rule Chain Id will cause error. Omit this field to create new rule chain.")
    public RuleChainId getId() {
        return (RuleChainId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the rule chain creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    public JsonNode getConfiguration() {
        return BaseDataWithAdditionalInfo.getJson(() -> this.configuration, () -> this.configurationBytes);
    }

    public void setConfiguration(JsonNode data) {
        RuleChain.setJson(data, json -> {
            this.configuration = json;
        }, bytes -> {
            this.configurationBytes = bytes;
        });
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.RULE_CHAIN;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public RuleChainType getType() {
        return this.type;
    }

    public RuleNodeId getFirstRuleNodeId() {
        return this.firstRuleNodeId;
    }

    public boolean isRoot() {
        return this.root;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public RuleChainId getExternalId() {
        return this.externalId;
    }

    public byte[] getConfigurationBytes() {
        return this.configurationBytes;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(RuleChainType type) {
        this.type = type;
    }

    public void setFirstRuleNodeId(RuleNodeId firstRuleNodeId) {
        this.firstRuleNodeId = firstRuleNodeId;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    public void setExternalId(RuleChainId externalId) {
        this.externalId = externalId;
    }

    @JsonIgnore
    public void setConfigurationBytes(byte[] configurationBytes) {
        this.configurationBytes = configurationBytes;
    }

    @Override
    public String toString() {
        return "RuleChain(tenantId=" + this.getTenantId() + ", name=" + this.getName() + ", type=" + this.getType() + ", firstRuleNodeId=" + this.getFirstRuleNodeId() + ", root=" + this.isRoot() + ", debugMode=" + this.isDebugMode() + ", configuration=" + this.getConfiguration() + ", externalId=" + this.getExternalId() + ", configurationBytes=" + Arrays.toString(this.getConfigurationBytes()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleChain)) {
            return false;
        }
        RuleChain other = (RuleChain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isRoot() != other.isRoot()) {
            return false;
        }
        if (this.isDebugMode() != other.isDebugMode()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        RuleChainType this$type = this.getType();
        RuleChainType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        RuleNodeId this$firstRuleNodeId = this.getFirstRuleNodeId();
        RuleNodeId other$firstRuleNodeId = other.getFirstRuleNodeId();
        if (this$firstRuleNodeId == null ? other$firstRuleNodeId != null : !((Object)this$firstRuleNodeId).equals(other$firstRuleNodeId)) {
            return false;
        }
        RuleChainId this$externalId = this.getExternalId();
        RuleChainId other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId)) {
            return false;
        }
        return Arrays.equals(this.getConfigurationBytes(), other.getConfigurationBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleChain;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isRoot() ? 79 : 97);
        result = result * 59 + (this.isDebugMode() ? 79 : 97);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        RuleChainType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        RuleNodeId $firstRuleNodeId = this.getFirstRuleNodeId();
        result = result * 59 + ($firstRuleNodeId == null ? 43 : ((Object)$firstRuleNodeId).hashCode());
        RuleChainId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        result = result * 59 + Arrays.hashCode(this.getConfigurationBytes());
        return result;
    }
}

