/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.query;

import java.util.HashMap;
import java.util.Map;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.common.data.query.TsValue;

public class AlarmData
extends AlarmInfo {
    private static final long serialVersionUID = -7042457913823369638L;
    private final EntityId entityId;
    private final Map<EntityKeyType, Map<String, TsValue>> latest;

    public AlarmData(AlarmInfo main, AlarmData prototype) {
        super(main);
        this.entityId = prototype.entityId;
        this.latest = new HashMap<EntityKeyType, Map<String, TsValue>>();
        this.latest.putAll(prototype.getLatest());
    }

    public AlarmData(Alarm alarm, EntityId entityId) {
        super(alarm);
        this.entityId = entityId;
        this.latest = new HashMap<EntityKeyType, Map<String, TsValue>>();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmData)) {
            return false;
        }
        AlarmData other = (AlarmData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        Map<EntityKeyType, Map<String, TsValue>> this$latest = this.getLatest();
        Map<EntityKeyType, Map<String, TsValue>> other$latest = other.getLatest();
        return !(this$latest == null ? other$latest != null : !((Object)this$latest).equals(other$latest));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AlarmData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        Map<EntityKeyType, Map<String, TsValue>> $latest = this.getLatest();
        result = result * 59 + ($latest == null ? 43 : ((Object)$latest).hashCode());
        return result;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public Map<EntityKeyType, Map<String, TsValue>> getLatest() {
        return this.latest;
    }
}

