/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.query;

import java.beans.ConstructorProperties;
import java.util.List;
import org.thingsboard.server.common.data.alarm.AlarmSearchStatus;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.query.EntityCountQuery;

public class AlarmCountQuery
extends EntityCountQuery {
    private long startTs;
    private long endTs;
    private long timeWindow;
    private List<String> typeList;
    private List<AlarmSearchStatus> statusList;
    private List<AlarmSeverity> severityList;
    private boolean searchPropagatedAlarms;
    private UserId assigneeId;

    public static AlarmCountQueryBuilder builder() {
        return new AlarmCountQueryBuilder();
    }

    public AlarmCountQuery() {
    }

    @ConstructorProperties(value={"startTs", "endTs", "timeWindow", "typeList", "statusList", "severityList", "searchPropagatedAlarms", "assigneeId"})
    public AlarmCountQuery(long startTs, long endTs, long timeWindow, List<String> typeList, List<AlarmSearchStatus> statusList, List<AlarmSeverity> severityList, boolean searchPropagatedAlarms, UserId assigneeId) {
        this.startTs = startTs;
        this.endTs = endTs;
        this.timeWindow = timeWindow;
        this.typeList = typeList;
        this.statusList = statusList;
        this.severityList = severityList;
        this.searchPropagatedAlarms = searchPropagatedAlarms;
        this.assigneeId = assigneeId;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public long getTimeWindow() {
        return this.timeWindow;
    }

    public List<String> getTypeList() {
        return this.typeList;
    }

    public List<AlarmSearchStatus> getStatusList() {
        return this.statusList;
    }

    public List<AlarmSeverity> getSeverityList() {
        return this.severityList;
    }

    public boolean isSearchPropagatedAlarms() {
        return this.searchPropagatedAlarms;
    }

    public UserId getAssigneeId() {
        return this.assigneeId;
    }

    @Override
    public String toString() {
        return "AlarmCountQuery(startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", timeWindow=" + this.getTimeWindow() + ", typeList=" + this.getTypeList() + ", statusList=" + this.getStatusList() + ", severityList=" + this.getSeverityList() + ", searchPropagatedAlarms=" + this.isSearchPropagatedAlarms() + ", assigneeId=" + this.getAssigneeId() + ")";
    }

    public static class AlarmCountQueryBuilder {
        private long startTs;
        private long endTs;
        private long timeWindow;
        private List<String> typeList;
        private List<AlarmSearchStatus> statusList;
        private List<AlarmSeverity> severityList;
        private boolean searchPropagatedAlarms;
        private UserId assigneeId;

        AlarmCountQueryBuilder() {
        }

        public AlarmCountQueryBuilder startTs(long startTs) {
            this.startTs = startTs;
            return this;
        }

        public AlarmCountQueryBuilder endTs(long endTs) {
            this.endTs = endTs;
            return this;
        }

        public AlarmCountQueryBuilder timeWindow(long timeWindow) {
            this.timeWindow = timeWindow;
            return this;
        }

        public AlarmCountQueryBuilder typeList(List<String> typeList) {
            this.typeList = typeList;
            return this;
        }

        public AlarmCountQueryBuilder statusList(List<AlarmSearchStatus> statusList) {
            this.statusList = statusList;
            return this;
        }

        public AlarmCountQueryBuilder severityList(List<AlarmSeverity> severityList) {
            this.severityList = severityList;
            return this;
        }

        public AlarmCountQueryBuilder searchPropagatedAlarms(boolean searchPropagatedAlarms) {
            this.searchPropagatedAlarms = searchPropagatedAlarms;
            return this;
        }

        public AlarmCountQueryBuilder assigneeId(UserId assigneeId) {
            this.assigneeId = assigneeId;
            return this;
        }

        public AlarmCountQuery build() {
            return new AlarmCountQuery(this.startTs, this.endTs, this.timeWindow, this.typeList, this.statusList, this.severityList, this.searchPropagatedAlarms, this.assigneeId);
        }

        public String toString() {
            return "AlarmCountQuery.AlarmCountQueryBuilder(startTs=" + this.startTs + ", endTs=" + this.endTs + ", timeWindow=" + this.timeWindow + ", typeList=" + this.typeList + ", statusList=" + this.statusList + ", severityList=" + this.severityList + ", searchPropagatedAlarms=" + this.searchPropagatedAlarms + ", assigneeId=" + this.assigneeId + ")";
        }
    }
}

