/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.targets.slack;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.beans.ConstructorProperties;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.thingsboard.server.common.data.notification.targets.NotificationRecipient;
import org.thingsboard.server.common.data.notification.targets.slack.SlackConversationType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SlackConversation
implements NotificationRecipient {
    @NotNull
    private SlackConversationType type;
    @NotEmpty
    private String id;
    @NotEmpty
    private String name;
    private String wholeName;
    private String email;

    @Override
    public String getTitle() {
        if (this.type == SlackConversationType.DIRECT) {
            return (String)StringUtils.defaultIfEmpty((CharSequence)this.wholeName, (CharSequence)this.name);
        }
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getFirstName() {
        String firstName;
        String string = firstName = StringUtils.contains((CharSequence)this.wholeName, (CharSequence)" ") ? this.wholeName.split(" ")[0] : this.wholeName;
        if (StringUtils.isEmpty((CharSequence)firstName)) {
            firstName = this.name;
        }
        return firstName;
    }

    @Override
    @JsonIgnore
    public String getLastName() {
        return StringUtils.contains((CharSequence)this.wholeName, (CharSequence)" ") ? this.wholeName.split(" ")[1] : null;
    }

    @JsonIgnore
    public String getPointer() {
        return this.type == SlackConversationType.DIRECT ? "@" : "#";
    }

    public static SlackConversationBuilder builder() {
        return new SlackConversationBuilder();
    }

    public SlackConversationType getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getWholeName() {
        return this.wholeName;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public void setType(SlackConversationType type) {
        this.type = type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setWholeName(String wholeName) {
        this.wholeName = wholeName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlackConversation)) {
            return false;
        }
        SlackConversation other = (SlackConversation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SlackConversationType this$type = this.getType();
        SlackConversationType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$wholeName = this.getWholeName();
        String other$wholeName = other.getWholeName();
        if (this$wholeName == null ? other$wholeName != null : !this$wholeName.equals(other$wholeName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        return !(this$email == null ? other$email != null : !this$email.equals(other$email));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlackConversation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SlackConversationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $wholeName = this.getWholeName();
        result = result * 59 + ($wholeName == null ? 43 : $wholeName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        return result;
    }

    public String toString() {
        return "SlackConversation(type=" + this.getType() + ", id=" + this.getId() + ", name=" + this.getName() + ", wholeName=" + this.getWholeName() + ", email=" + this.getEmail() + ")";
    }

    public SlackConversation() {
    }

    @ConstructorProperties(value={"type", "id", "name", "wholeName", "email"})
    public SlackConversation(SlackConversationType type, String id, String name, String wholeName, String email) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.wholeName = wholeName;
        this.email = email;
    }

    public static class SlackConversationBuilder {
        private SlackConversationType type;
        private String id;
        private String name;
        private String wholeName;
        private String email;

        SlackConversationBuilder() {
        }

        public SlackConversationBuilder type(SlackConversationType type) {
            this.type = type;
            return this;
        }

        public SlackConversationBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SlackConversationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SlackConversationBuilder wholeName(String wholeName) {
            this.wholeName = wholeName;
            return this;
        }

        public SlackConversationBuilder email(String email) {
            this.email = email;
            return this;
        }

        public SlackConversation build() {
            return new SlackConversation(this.type, this.id, this.name, this.wholeName, this.email);
        }

        public String toString() {
            return "SlackConversation.SlackConversationBuilder(type=" + this.type + ", id=" + this.id + ", name=" + this.name + ", wholeName=" + this.wholeName + ", email=" + this.email + ")";
        }
    }
}

