/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.targets;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Set;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;

public enum NotificationTargetType {
    PLATFORM_USERS(Set.of(NotificationDeliveryMethod.WEB, NotificationDeliveryMethod.EMAIL, NotificationDeliveryMethod.SMS)),
    SLACK(Set.of(NotificationDeliveryMethod.SLACK)),
    MICROSOFT_TEAMS(Set.of(NotificationDeliveryMethod.MICROSOFT_TEAMS));

    private final Set<NotificationDeliveryMethod> supportedDeliveryMethods;

    public static NotificationTargetType forDeliveryMethod(NotificationDeliveryMethod deliveryMethod) {
        return Arrays.stream(NotificationTargetType.values()).filter(targetType -> targetType.getSupportedDeliveryMethods().contains((Object)deliveryMethod)).findFirst().orElse(null);
    }

    @ConstructorProperties(value={"supportedDeliveryMethods"})
    private NotificationTargetType(Set<NotificationDeliveryMethod> supportedDeliveryMethods) {
        this.supportedDeliveryMethods = supportedDeliveryMethods;
    }

    public Set<NotificationDeliveryMethod> getSupportedDeliveryMethods() {
        return this.supportedDeliveryMethods;
    }
}

