/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.rule.trigger;

import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.UpdateMessage;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;

public class NewPlatformVersionTrigger
implements NotificationRuleTrigger {
    private final UpdateMessage updateInfo;

    @Override
    public NotificationRuleTriggerType getType() {
        return NotificationRuleTriggerType.NEW_PLATFORM_VERSION;
    }

    @Override
    public TenantId getTenantId() {
        return TenantId.SYS_TENANT_ID;
    }

    @Override
    public EntityId getOriginatorEntityId() {
        return TenantId.SYS_TENANT_ID;
    }

    @Override
    public boolean deduplicate() {
        return true;
    }

    @Override
    public String getDeduplicationKey() {
        return String.join((CharSequence)":", NotificationRuleTrigger.super.getDeduplicationKey(), this.updateInfo.getCurrentVersion(), this.updateInfo.getLatestVersion());
    }

    @Override
    public long getDefaultDeduplicationDuration() {
        return 0L;
    }

    @ConstructorProperties(value={"updateInfo"})
    NewPlatformVersionTrigger(UpdateMessage updateInfo) {
        this.updateInfo = updateInfo;
    }

    public static NewPlatformVersionTriggerBuilder builder() {
        return new NewPlatformVersionTriggerBuilder();
    }

    public UpdateMessage getUpdateInfo() {
        return this.updateInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewPlatformVersionTrigger)) {
            return false;
        }
        NewPlatformVersionTrigger other = (NewPlatformVersionTrigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UpdateMessage this$updateInfo = this.getUpdateInfo();
        UpdateMessage other$updateInfo = other.getUpdateInfo();
        return !(this$updateInfo == null ? other$updateInfo != null : !((Object)this$updateInfo).equals(other$updateInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NewPlatformVersionTrigger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UpdateMessage $updateInfo = this.getUpdateInfo();
        result = result * 59 + ($updateInfo == null ? 43 : ((Object)$updateInfo).hashCode());
        return result;
    }

    public String toString() {
        return "NewPlatformVersionTrigger(updateInfo=" + this.getUpdateInfo() + ")";
    }

    public static class NewPlatformVersionTriggerBuilder {
        private UpdateMessage updateInfo;

        NewPlatformVersionTriggerBuilder() {
        }

        public NewPlatformVersionTriggerBuilder updateInfo(UpdateMessage updateInfo) {
            this.updateInfo = updateInfo;
            return this;
        }

        public NewPlatformVersionTrigger build() {
            return new NewPlatformVersionTrigger(this.updateInfo);
        }

        public String toString() {
            return "NewPlatformVersionTrigger.NewPlatformVersionTriggerBuilder(updateInfo=" + this.updateInfo + ")";
        }
    }
}

