/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.rule.trigger;

import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;

public class EntityActionTrigger
implements NotificationRuleTrigger {
    private final TenantId tenantId;
    private final EntityId entityId;
    private final HasName entity;
    private final ActionType actionType;
    private final User user;

    @Override
    public NotificationRuleTriggerType getType() {
        return NotificationRuleTriggerType.ENTITY_ACTION;
    }

    @Override
    public EntityId getOriginatorEntityId() {
        return this.entityId;
    }

    @ConstructorProperties(value={"tenantId", "entityId", "entity", "actionType", "user"})
    EntityActionTrigger(TenantId tenantId, EntityId entityId, HasName entity, ActionType actionType, User user) {
        this.tenantId = tenantId;
        this.entityId = entityId;
        this.entity = entity;
        this.actionType = actionType;
        this.user = user;
    }

    public static EntityActionTriggerBuilder builder() {
        return new EntityActionTriggerBuilder();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public HasName getEntity() {
        return this.entity;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public User getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityActionTrigger)) {
            return false;
        }
        EntityActionTrigger other = (EntityActionTrigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        HasName this$entity = this.getEntity();
        HasName other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        ActionType this$actionType = this.getActionType();
        ActionType other$actionType = other.getActionType();
        if (this$actionType == null ? other$actionType != null : !((Object)((Object)this$actionType)).equals((Object)other$actionType)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityActionTrigger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        HasName $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        ActionType $actionType = this.getActionType();
        result = result * 59 + ($actionType == null ? 43 : ((Object)((Object)$actionType)).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        return result;
    }

    public String toString() {
        return "EntityActionTrigger(tenantId=" + this.getTenantId() + ", entityId=" + this.getEntityId() + ", entity=" + this.getEntity() + ", actionType=" + this.getActionType() + ", user=" + this.getUser() + ")";
    }

    public static class EntityActionTriggerBuilder {
        private TenantId tenantId;
        private EntityId entityId;
        private HasName entity;
        private ActionType actionType;
        private User user;

        EntityActionTriggerBuilder() {
        }

        public EntityActionTriggerBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public EntityActionTriggerBuilder entityId(EntityId entityId) {
            this.entityId = entityId;
            return this;
        }

        public EntityActionTriggerBuilder entity(HasName entity) {
            this.entity = entity;
            return this;
        }

        public EntityActionTriggerBuilder actionType(ActionType actionType) {
            this.actionType = actionType;
            return this;
        }

        public EntityActionTriggerBuilder user(User user) {
            this.user = user;
            return this;
        }

        public EntityActionTrigger build() {
            return new EntityActionTrigger(this.tenantId, this.entityId, this.entity, this.actionType, this.user);
        }

        public String toString() {
            return "EntityActionTrigger.EntityActionTriggerBuilder(tenantId=" + this.tenantId + ", entityId=" + this.entityId + ", entity=" + this.entity + ", actionType=" + this.actionType + ", user=" + this.user + ")";
        }
    }
}

