/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.rule.trigger;

import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;

public class EntitiesLimitTrigger
implements NotificationRuleTrigger {
    private final TenantId tenantId;
    private final EntityType entityType;
    private long limit;
    private long currentCount;

    @Override
    public NotificationRuleTriggerType getType() {
        return NotificationRuleTriggerType.ENTITIES_LIMIT;
    }

    @Override
    public EntityId getOriginatorEntityId() {
        return this.tenantId;
    }

    @ConstructorProperties(value={"tenantId", "entityType", "limit", "currentCount"})
    EntitiesLimitTrigger(TenantId tenantId, EntityType entityType, long limit, long currentCount) {
        this.tenantId = tenantId;
        this.entityType = entityType;
        this.limit = limit;
        this.currentCount = currentCount;
    }

    public static EntitiesLimitTriggerBuilder builder() {
        return new EntitiesLimitTriggerBuilder();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getCurrentCount() {
        return this.currentCount;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setCurrentCount(long currentCount) {
        this.currentCount = currentCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntitiesLimitTrigger)) {
            return false;
        }
        EntitiesLimitTrigger other = (EntitiesLimitTrigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (this.getCurrentCount() != other.getCurrentCount()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        EntityType this$entityType = this.getEntityType();
        EntityType other$entityType = other.getEntityType();
        return !(this$entityType == null ? other$entityType != null : !((Object)((Object)this$entityType)).equals((Object)other$entityType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntitiesLimitTrigger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $limit = this.getLimit();
        result = result * 59 + (int)($limit >>> 32 ^ $limit);
        long $currentCount = this.getCurrentCount();
        result = result * 59 + (int)($currentCount >>> 32 ^ $currentCount);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        EntityType $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : ((Object)((Object)$entityType)).hashCode());
        return result;
    }

    public String toString() {
        return "EntitiesLimitTrigger(tenantId=" + this.getTenantId() + ", entityType=" + this.getEntityType() + ", limit=" + this.getLimit() + ", currentCount=" + this.getCurrentCount() + ")";
    }

    public static class EntitiesLimitTriggerBuilder {
        private TenantId tenantId;
        private EntityType entityType;
        private long limit;
        private long currentCount;

        EntitiesLimitTriggerBuilder() {
        }

        public EntitiesLimitTriggerBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public EntitiesLimitTriggerBuilder entityType(EntityType entityType) {
            this.entityType = entityType;
            return this;
        }

        public EntitiesLimitTriggerBuilder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public EntitiesLimitTriggerBuilder currentCount(long currentCount) {
            this.currentCount = currentCount;
            return this;
        }

        public EntitiesLimitTrigger build() {
            return new EntitiesLimitTrigger(this.tenantId, this.entityType, this.limit, this.currentCount);
        }

        public String toString() {
            return "EntitiesLimitTrigger.EntitiesLimitTriggerBuilder(tenantId=" + this.tenantId + ", entityType=" + this.entityType + ", limit=" + this.limit + ", currentCount=" + this.currentCount + ")";
        }
    }
}

