/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.rule.trigger;

import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.ApiUsageRecordState;
import org.thingsboard.server.common.data.ApiUsageStateValue;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;

public class ApiUsageLimitTrigger
implements NotificationRuleTrigger {
    private final TenantId tenantId;
    private final ApiUsageRecordState state;
    private final ApiUsageStateValue status;

    @Override
    public NotificationRuleTriggerType getType() {
        return NotificationRuleTriggerType.API_USAGE_LIMIT;
    }

    @Override
    public EntityId getOriginatorEntityId() {
        return this.tenantId;
    }

    @ConstructorProperties(value={"tenantId", "state", "status"})
    ApiUsageLimitTrigger(TenantId tenantId, ApiUsageRecordState state, ApiUsageStateValue status) {
        this.tenantId = tenantId;
        this.state = state;
        this.status = status;
    }

    public static ApiUsageLimitTriggerBuilder builder() {
        return new ApiUsageLimitTriggerBuilder();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public ApiUsageRecordState getState() {
        return this.state;
    }

    public ApiUsageStateValue getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiUsageLimitTrigger)) {
            return false;
        }
        ApiUsageLimitTrigger other = (ApiUsageLimitTrigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        ApiUsageRecordState this$state = this.getState();
        ApiUsageRecordState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        ApiUsageStateValue this$status = this.getStatus();
        ApiUsageStateValue other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiUsageLimitTrigger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        ApiUsageRecordState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        ApiUsageStateValue $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "ApiUsageLimitTrigger(tenantId=" + this.getTenantId() + ", state=" + this.getState() + ", status=" + this.getStatus() + ")";
    }

    public static class ApiUsageLimitTriggerBuilder {
        private TenantId tenantId;
        private ApiUsageRecordState state;
        private ApiUsageStateValue status;

        ApiUsageLimitTriggerBuilder() {
        }

        public ApiUsageLimitTriggerBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ApiUsageLimitTriggerBuilder state(ApiUsageRecordState state) {
            this.state = state;
            return this;
        }

        public ApiUsageLimitTriggerBuilder status(ApiUsageStateValue status) {
            this.status = status;
            return this;
        }

        public ApiUsageLimitTrigger build() {
            return new ApiUsageLimitTrigger(this.tenantId, this.state, this.status);
        }

        public String toString() {
            return "ApiUsageLimitTrigger.ApiUsageLimitTriggerBuilder(tenantId=" + this.tenantId + ", state=" + this.state + ", status=" + this.status + ")";
        }
    }
}

