/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.rule.trigger;

import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;

public class AlarmCommentTrigger
implements NotificationRuleTrigger {
    private final TenantId tenantId;
    private final AlarmComment comment;
    private final Alarm alarm;
    private final ActionType actionType;
    private final User user;

    @Override
    public NotificationRuleTriggerType getType() {
        return NotificationRuleTriggerType.ALARM_COMMENT;
    }

    @Override
    public EntityId getOriginatorEntityId() {
        return this.alarm.getId();
    }

    @ConstructorProperties(value={"tenantId", "comment", "alarm", "actionType", "user"})
    AlarmCommentTrigger(TenantId tenantId, AlarmComment comment, Alarm alarm, ActionType actionType, User user) {
        this.tenantId = tenantId;
        this.comment = comment;
        this.alarm = alarm;
        this.actionType = actionType;
        this.user = user;
    }

    public static AlarmCommentTriggerBuilder builder() {
        return new AlarmCommentTriggerBuilder();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public AlarmComment getComment() {
        return this.comment;
    }

    public Alarm getAlarm() {
        return this.alarm;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public User getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmCommentTrigger)) {
            return false;
        }
        AlarmCommentTrigger other = (AlarmCommentTrigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        AlarmComment this$comment = this.getComment();
        AlarmComment other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !((Object)this$comment).equals(other$comment)) {
            return false;
        }
        Alarm this$alarm = this.getAlarm();
        Alarm other$alarm = other.getAlarm();
        if (this$alarm == null ? other$alarm != null : !((Object)this$alarm).equals(other$alarm)) {
            return false;
        }
        ActionType this$actionType = this.getActionType();
        ActionType other$actionType = other.getActionType();
        if (this$actionType == null ? other$actionType != null : !((Object)((Object)this$actionType)).equals((Object)other$actionType)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmCommentTrigger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        AlarmComment $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : ((Object)$comment).hashCode());
        Alarm $alarm = this.getAlarm();
        result = result * 59 + ($alarm == null ? 43 : ((Object)$alarm).hashCode());
        ActionType $actionType = this.getActionType();
        result = result * 59 + ($actionType == null ? 43 : ((Object)((Object)$actionType)).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        return result;
    }

    public String toString() {
        return "AlarmCommentTrigger(tenantId=" + this.getTenantId() + ", comment=" + this.getComment() + ", alarm=" + this.getAlarm() + ", actionType=" + this.getActionType() + ", user=" + this.getUser() + ")";
    }

    public static class AlarmCommentTriggerBuilder {
        private TenantId tenantId;
        private AlarmComment comment;
        private Alarm alarm;
        private ActionType actionType;
        private User user;

        AlarmCommentTriggerBuilder() {
        }

        public AlarmCommentTriggerBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public AlarmCommentTriggerBuilder comment(AlarmComment comment) {
            this.comment = comment;
            return this;
        }

        public AlarmCommentTriggerBuilder alarm(Alarm alarm) {
            this.alarm = alarm;
            return this;
        }

        public AlarmCommentTriggerBuilder actionType(ActionType actionType) {
            this.actionType = actionType;
            return this;
        }

        public AlarmCommentTriggerBuilder user(User user) {
            this.user = user;
            return this;
        }

        public AlarmCommentTrigger build() {
            return new AlarmCommentTrigger(this.tenantId, this.comment, this.alarm, this.actionType, this.user);
        }

        public String toString() {
            return "AlarmCommentTrigger.AlarmCommentTriggerBuilder(tenantId=" + this.tenantId + ", comment=" + this.comment + ", alarm=" + this.alarm + ", actionType=" + this.actionType + ", user=" + this.user + ")";
        }
    }
}

