/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.info;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.notification.info.NotificationInfo;

public class RuleEngineOriginatedNotificationInfo
implements NotificationInfo {
    private EntityId msgOriginator;
    private String msgType;
    private Map<String, String> msgMetadata;
    private Map<String, String> msgData;

    @Override
    public Map<String, String> getTemplateData() {
        HashMap<String, String> templateData = new HashMap<String, String>();
        templateData.putAll(this.msgMetadata);
        templateData.putAll(this.msgData);
        templateData.put("originatorType", this.msgOriginator.getEntityType().getNormalName());
        templateData.put("originatorId", this.msgOriginator.getId().toString());
        templateData.put("msgType", this.msgType);
        return templateData;
    }

    @Override
    public EntityId getStateEntityId() {
        return this.msgOriginator;
    }

    public static RuleEngineOriginatedNotificationInfoBuilder builder() {
        return new RuleEngineOriginatedNotificationInfoBuilder();
    }

    public EntityId getMsgOriginator() {
        return this.msgOriginator;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public Map<String, String> getMsgMetadata() {
        return this.msgMetadata;
    }

    public Map<String, String> getMsgData() {
        return this.msgData;
    }

    public void setMsgOriginator(EntityId msgOriginator) {
        this.msgOriginator = msgOriginator;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setMsgMetadata(Map<String, String> msgMetadata) {
        this.msgMetadata = msgMetadata;
    }

    public void setMsgData(Map<String, String> msgData) {
        this.msgData = msgData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleEngineOriginatedNotificationInfo)) {
            return false;
        }
        RuleEngineOriginatedNotificationInfo other = (RuleEngineOriginatedNotificationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityId this$msgOriginator = this.getMsgOriginator();
        EntityId other$msgOriginator = other.getMsgOriginator();
        if (this$msgOriginator == null ? other$msgOriginator != null : !this$msgOriginator.equals(other$msgOriginator)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        Map<String, String> this$msgMetadata = this.getMsgMetadata();
        Map<String, String> other$msgMetadata = other.getMsgMetadata();
        if (this$msgMetadata == null ? other$msgMetadata != null : !((Object)this$msgMetadata).equals(other$msgMetadata)) {
            return false;
        }
        Map<String, String> this$msgData = this.getMsgData();
        Map<String, String> other$msgData = other.getMsgData();
        return !(this$msgData == null ? other$msgData != null : !((Object)this$msgData).equals(other$msgData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleEngineOriginatedNotificationInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityId $msgOriginator = this.getMsgOriginator();
        result = result * 59 + ($msgOriginator == null ? 43 : $msgOriginator.hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        Map<String, String> $msgMetadata = this.getMsgMetadata();
        result = result * 59 + ($msgMetadata == null ? 43 : ((Object)$msgMetadata).hashCode());
        Map<String, String> $msgData = this.getMsgData();
        result = result * 59 + ($msgData == null ? 43 : ((Object)$msgData).hashCode());
        return result;
    }

    public String toString() {
        return "RuleEngineOriginatedNotificationInfo(msgOriginator=" + this.getMsgOriginator() + ", msgType=" + this.getMsgType() + ", msgMetadata=" + this.getMsgMetadata() + ", msgData=" + this.getMsgData() + ")";
    }

    @ConstructorProperties(value={"msgOriginator", "msgType", "msgMetadata", "msgData"})
    public RuleEngineOriginatedNotificationInfo(EntityId msgOriginator, String msgType, Map<String, String> msgMetadata, Map<String, String> msgData) {
        this.msgOriginator = msgOriginator;
        this.msgType = msgType;
        this.msgMetadata = msgMetadata;
        this.msgData = msgData;
    }

    public RuleEngineOriginatedNotificationInfo() {
    }

    public static class RuleEngineOriginatedNotificationInfoBuilder {
        private EntityId msgOriginator;
        private String msgType;
        private Map<String, String> msgMetadata;
        private Map<String, String> msgData;

        RuleEngineOriginatedNotificationInfoBuilder() {
        }

        public RuleEngineOriginatedNotificationInfoBuilder msgOriginator(EntityId msgOriginator) {
            this.msgOriginator = msgOriginator;
            return this;
        }

        public RuleEngineOriginatedNotificationInfoBuilder msgType(String msgType) {
            this.msgType = msgType;
            return this;
        }

        public RuleEngineOriginatedNotificationInfoBuilder msgMetadata(Map<String, String> msgMetadata) {
            this.msgMetadata = msgMetadata;
            return this;
        }

        public RuleEngineOriginatedNotificationInfoBuilder msgData(Map<String, String> msgData) {
            this.msgData = msgData;
            return this;
        }

        public RuleEngineOriginatedNotificationInfo build() {
            return new RuleEngineOriginatedNotificationInfo(this.msgOriginator, this.msgType, this.msgMetadata, this.msgData);
        }

        public String toString() {
            return "RuleEngineOriginatedNotificationInfo.RuleEngineOriginatedNotificationInfoBuilder(msgOriginator=" + this.msgOriginator + ", msgType=" + this.msgType + ", msgMetadata=" + this.msgMetadata + ", msgData=" + this.msgData + ")";
        }
    }
}

