/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.info;

import java.beans.ConstructorProperties;
import java.util.Map;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.util.CollectionsUtil;

public class RateLimitsNotificationInfo
implements RuleOriginatedNotificationInfo {
    private TenantId tenantId;
    private String tenantName;
    private LimitedApi api;
    private EntityId limitLevel;
    private String limitLevelEntityName;

    @Override
    public Map<String, String> getTemplateData() {
        return CollectionsUtil.mapOf("api", this.api.getLabel(), "limitLevelEntityType", this.limitLevel != null ? this.limitLevel.getEntityType().getNormalName() : null, "limitLevelEntityId", this.limitLevel != null ? this.limitLevel.getId().toString() : null, "limitLevelEntityName", this.limitLevelEntityName, "tenantName", this.tenantName, "tenantId", this.tenantId.toString());
    }

    @Override
    public TenantId getAffectedTenantId() {
        return this.tenantId;
    }

    public static RateLimitsNotificationInfoBuilder builder() {
        return new RateLimitsNotificationInfoBuilder();
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public LimitedApi getApi() {
        return this.api;
    }

    public EntityId getLimitLevel() {
        return this.limitLevel;
    }

    public String getLimitLevelEntityName() {
        return this.limitLevelEntityName;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public void setApi(LimitedApi api) {
        this.api = api;
    }

    public void setLimitLevel(EntityId limitLevel) {
        this.limitLevel = limitLevel;
    }

    public void setLimitLevelEntityName(String limitLevelEntityName) {
        this.limitLevelEntityName = limitLevelEntityName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RateLimitsNotificationInfo)) {
            return false;
        }
        RateLimitsNotificationInfo other = (RateLimitsNotificationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$tenantName = this.getTenantName();
        String other$tenantName = other.getTenantName();
        if (this$tenantName == null ? other$tenantName != null : !this$tenantName.equals(other$tenantName)) {
            return false;
        }
        LimitedApi this$api = this.getApi();
        LimitedApi other$api = other.getApi();
        if (this$api == null ? other$api != null : !((Object)((Object)this$api)).equals((Object)other$api)) {
            return false;
        }
        EntityId this$limitLevel = this.getLimitLevel();
        EntityId other$limitLevel = other.getLimitLevel();
        if (this$limitLevel == null ? other$limitLevel != null : !this$limitLevel.equals(other$limitLevel)) {
            return false;
        }
        String this$limitLevelEntityName = this.getLimitLevelEntityName();
        String other$limitLevelEntityName = other.getLimitLevelEntityName();
        return !(this$limitLevelEntityName == null ? other$limitLevelEntityName != null : !this$limitLevelEntityName.equals(other$limitLevelEntityName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RateLimitsNotificationInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $tenantName = this.getTenantName();
        result = result * 59 + ($tenantName == null ? 43 : $tenantName.hashCode());
        LimitedApi $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : ((Object)((Object)$api)).hashCode());
        EntityId $limitLevel = this.getLimitLevel();
        result = result * 59 + ($limitLevel == null ? 43 : $limitLevel.hashCode());
        String $limitLevelEntityName = this.getLimitLevelEntityName();
        result = result * 59 + ($limitLevelEntityName == null ? 43 : $limitLevelEntityName.hashCode());
        return result;
    }

    public String toString() {
        return "RateLimitsNotificationInfo(tenantId=" + this.getTenantId() + ", tenantName=" + this.getTenantName() + ", api=" + this.getApi() + ", limitLevel=" + this.getLimitLevel() + ", limitLevelEntityName=" + this.getLimitLevelEntityName() + ")";
    }

    public RateLimitsNotificationInfo() {
    }

    @ConstructorProperties(value={"tenantId", "tenantName", "api", "limitLevel", "limitLevelEntityName"})
    public RateLimitsNotificationInfo(TenantId tenantId, String tenantName, LimitedApi api, EntityId limitLevel, String limitLevelEntityName) {
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.api = api;
        this.limitLevel = limitLevel;
        this.limitLevelEntityName = limitLevelEntityName;
    }

    public static class RateLimitsNotificationInfoBuilder {
        private TenantId tenantId;
        private String tenantName;
        private LimitedApi api;
        private EntityId limitLevel;
        private String limitLevelEntityName;

        RateLimitsNotificationInfoBuilder() {
        }

        public RateLimitsNotificationInfoBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RateLimitsNotificationInfoBuilder tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public RateLimitsNotificationInfoBuilder api(LimitedApi api) {
            this.api = api;
            return this;
        }

        public RateLimitsNotificationInfoBuilder limitLevel(EntityId limitLevel) {
            this.limitLevel = limitLevel;
            return this;
        }

        public RateLimitsNotificationInfoBuilder limitLevelEntityName(String limitLevelEntityName) {
            this.limitLevelEntityName = limitLevelEntityName;
            return this;
        }

        public RateLimitsNotificationInfo build() {
            return new RateLimitsNotificationInfo(this.tenantId, this.tenantName, this.api, this.limitLevel, this.limitLevelEntityName);
        }

        public String toString() {
            return "RateLimitsNotificationInfo.RateLimitsNotificationInfoBuilder(tenantId=" + this.tenantId + ", tenantName=" + this.tenantName + ", api=" + this.api + ", limitLevel=" + this.limitLevel + ", limitLevelEntityName=" + this.limitLevelEntityName + ")";
        }
    }
}

