/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.thingsboard.server.common.data.notification.AlreadySentException;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.targets.NotificationRecipient;

public class NotificationRequestStats {
    private final Map<NotificationDeliveryMethod, AtomicInteger> sent;
    private final Map<NotificationDeliveryMethod, Map<String, String>> errors;
    private String error;
    @JsonIgnore
    private final Map<NotificationDeliveryMethod, Set<Object>> processedRecipients;

    public NotificationRequestStats() {
        this.sent = new ConcurrentHashMap<NotificationDeliveryMethod, AtomicInteger>();
        this.errors = new ConcurrentHashMap<NotificationDeliveryMethod, Map<String, String>>();
        this.processedRecipients = new ConcurrentHashMap<NotificationDeliveryMethod, Set<Object>>();
    }

    @JsonCreator
    public NotificationRequestStats(@JsonProperty(value="sent") Map<NotificationDeliveryMethod, AtomicInteger> sent, @JsonProperty(value="errors") Map<NotificationDeliveryMethod, Map<String, String>> errors, @JsonProperty(value="error") String error) {
        this.sent = sent;
        this.errors = errors;
        this.error = error;
        this.processedRecipients = Collections.emptyMap();
    }

    public void reportSent(NotificationDeliveryMethod deliveryMethod, NotificationRecipient recipient) {
        this.sent.computeIfAbsent(deliveryMethod, k -> new AtomicInteger()).incrementAndGet();
    }

    public void reportError(NotificationDeliveryMethod deliveryMethod, Throwable error, NotificationRecipient recipient) {
        if (error instanceof AlreadySentException) {
            return;
        }
        String errorMessage = error.getMessage();
        if (errorMessage == null) {
            errorMessage = error.getClass().getSimpleName();
        }
        this.errors.computeIfAbsent(deliveryMethod, k -> new ConcurrentHashMap()).put(recipient.getTitle(), errorMessage);
    }

    public void reportProcessed(NotificationDeliveryMethod deliveryMethod, Object recipientId) {
        this.processedRecipients.computeIfAbsent(deliveryMethod, k -> ConcurrentHashMap.newKeySet()).add(recipientId);
    }

    public boolean contains(NotificationDeliveryMethod deliveryMethod, Object recipientId) {
        Set<Object> processedRecipients = this.processedRecipients.get((Object)deliveryMethod);
        return processedRecipients != null && processedRecipients.contains(recipientId);
    }

    public Map<NotificationDeliveryMethod, AtomicInteger> getSent() {
        return this.sent;
    }

    public Map<NotificationDeliveryMethod, Map<String, String>> getErrors() {
        return this.errors;
    }

    public String getError() {
        return this.error;
    }

    public Map<NotificationDeliveryMethod, Set<Object>> getProcessedRecipients() {
        return this.processedRecipients;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationRequestStats)) {
            return false;
        }
        NotificationRequestStats other = (NotificationRequestStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<NotificationDeliveryMethod, AtomicInteger> this$sent = this.getSent();
        Map<NotificationDeliveryMethod, AtomicInteger> other$sent = other.getSent();
        if (this$sent == null ? other$sent != null : !((Object)this$sent).equals(other$sent)) {
            return false;
        }
        Map<NotificationDeliveryMethod, Map<String, String>> this$errors = this.getErrors();
        Map<NotificationDeliveryMethod, Map<String, String>> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        Map<NotificationDeliveryMethod, Set<Object>> this$processedRecipients = this.getProcessedRecipients();
        Map<NotificationDeliveryMethod, Set<Object>> other$processedRecipients = other.getProcessedRecipients();
        return !(this$processedRecipients == null ? other$processedRecipients != null : !((Object)this$processedRecipients).equals(other$processedRecipients));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotificationRequestStats;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<NotificationDeliveryMethod, AtomicInteger> $sent = this.getSent();
        result = result * 59 + ($sent == null ? 43 : ((Object)$sent).hashCode());
        Map<NotificationDeliveryMethod, Map<String, String>> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        Map<NotificationDeliveryMethod, Set<Object>> $processedRecipients = this.getProcessedRecipients();
        result = result * 59 + ($processedRecipients == null ? 43 : ((Object)$processedRecipients).hashCode());
        return result;
    }

    public String toString() {
        return "NotificationRequestStats(sent=" + this.getSent() + ", errors=" + this.getErrors() + ", error=" + this.getError() + ", processedRecipients=" + this.getProcessedRecipients() + ")";
    }
}

