/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.id.NotificationId;
import org.thingsboard.server.common.data.id.NotificationRequestId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.notification.NotificationStatus;
import org.thingsboard.server.common.data.notification.NotificationType;
import org.thingsboard.server.common.data.notification.info.NotificationInfo;

public class Notification
extends BaseData<NotificationId> {
    private NotificationRequestId requestId;
    private UserId recipientId;
    private NotificationType type;
    private String subject;
    private String text;
    private JsonNode additionalConfig;
    private NotificationInfo info;
    private NotificationStatus status;

    public static NotificationBuilder builder() {
        return new NotificationBuilder();
    }

    public NotificationRequestId getRequestId() {
        return this.requestId;
    }

    public UserId getRecipientId() {
        return this.recipientId;
    }

    public NotificationType getType() {
        return this.type;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getText() {
        return this.text;
    }

    public JsonNode getAdditionalConfig() {
        return this.additionalConfig;
    }

    public NotificationInfo getInfo() {
        return this.info;
    }

    public NotificationStatus getStatus() {
        return this.status;
    }

    public void setRequestId(NotificationRequestId requestId) {
        this.requestId = requestId;
    }

    public void setRecipientId(UserId recipientId) {
        this.recipientId = recipientId;
    }

    public void setType(NotificationType type) {
        this.type = type;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAdditionalConfig(JsonNode additionalConfig) {
        this.additionalConfig = additionalConfig;
    }

    public void setInfo(NotificationInfo info) {
        this.info = info;
    }

    public void setStatus(NotificationStatus status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "Notification(requestId=" + this.getRequestId() + ", recipientId=" + this.getRecipientId() + ", type=" + this.getType() + ", subject=" + this.getSubject() + ", text=" + this.getText() + ", additionalConfig=" + this.getAdditionalConfig() + ", info=" + this.getInfo() + ", status=" + this.getStatus() + ")";
    }

    @ConstructorProperties(value={"requestId", "recipientId", "type", "subject", "text", "additionalConfig", "info", "status"})
    public Notification(NotificationRequestId requestId, UserId recipientId, NotificationType type, String subject, String text, JsonNode additionalConfig, NotificationInfo info, NotificationStatus status) {
        this.requestId = requestId;
        this.recipientId = recipientId;
        this.type = type;
        this.subject = subject;
        this.text = text;
        this.additionalConfig = additionalConfig;
        this.info = info;
        this.status = status;
    }

    public Notification() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NotificationRequestId this$requestId = this.getRequestId();
        NotificationRequestId other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !((Object)this$requestId).equals(other$requestId)) {
            return false;
        }
        UserId this$recipientId = this.getRecipientId();
        UserId other$recipientId = other.getRecipientId();
        if (this$recipientId == null ? other$recipientId != null : !((Object)this$recipientId).equals(other$recipientId)) {
            return false;
        }
        NotificationType this$type = this.getType();
        NotificationType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        JsonNode this$additionalConfig = this.getAdditionalConfig();
        JsonNode other$additionalConfig = other.getAdditionalConfig();
        if (this$additionalConfig == null ? other$additionalConfig != null : !this$additionalConfig.equals(other$additionalConfig)) {
            return false;
        }
        NotificationInfo this$info = this.getInfo();
        NotificationInfo other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
            return false;
        }
        NotificationStatus this$status = this.getStatus();
        NotificationStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Notification;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        NotificationRequestId $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : ((Object)$requestId).hashCode());
        UserId $recipientId = this.getRecipientId();
        result = result * 59 + ($recipientId == null ? 43 : ((Object)$recipientId).hashCode());
        NotificationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        JsonNode $additionalConfig = this.getAdditionalConfig();
        result = result * 59 + ($additionalConfig == null ? 43 : $additionalConfig.hashCode());
        NotificationInfo $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        NotificationStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public static class NotificationBuilder {
        private NotificationRequestId requestId;
        private UserId recipientId;
        private NotificationType type;
        private String subject;
        private String text;
        private JsonNode additionalConfig;
        private NotificationInfo info;
        private NotificationStatus status;

        NotificationBuilder() {
        }

        public NotificationBuilder requestId(NotificationRequestId requestId) {
            this.requestId = requestId;
            return this;
        }

        public NotificationBuilder recipientId(UserId recipientId) {
            this.recipientId = recipientId;
            return this;
        }

        public NotificationBuilder type(NotificationType type) {
            this.type = type;
            return this;
        }

        public NotificationBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public NotificationBuilder text(String text) {
            this.text = text;
            return this;
        }

        public NotificationBuilder additionalConfig(JsonNode additionalConfig) {
            this.additionalConfig = additionalConfig;
            return this;
        }

        public NotificationBuilder info(NotificationInfo info) {
            this.info = info;
            return this;
        }

        public NotificationBuilder status(NotificationStatus status) {
            this.status = status;
            return this;
        }

        public Notification build() {
            return new Notification(this.requestId, this.recipientId, this.type, this.subject, this.text, this.additionalConfig, this.info, this.status);
        }

        public String toString() {
            return "Notification.NotificationBuilder(requestId=" + this.requestId + ", recipientId=" + this.recipientId + ", type=" + this.type + ", subject=" + this.subject + ", text=" + this.text + ", additionalConfig=" + this.additionalConfig + ", info=" + this.info + ", status=" + this.status + ")";
        }
    }
}

