/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.kv;

import java.util.Objects;
import java.util.Optional;
import org.thingsboard.server.common.data.kv.BasicKvEntry;
import org.thingsboard.server.common.data.kv.DataType;

public class JsonDataEntry
extends BasicKvEntry {
    private final String value;

    public JsonDataEntry(String key, String value) {
        super(key);
        this.value = value;
    }

    @Override
    public DataType getDataType() {
        return DataType.JSON;
    }

    @Override
    public Optional<String> getJsonValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonDataEntry)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonDataEntry that = (JsonDataEntry)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public String toString() {
        return "JsonDataEntry{value=" + this.value + "} " + super.toString();
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }
}

