/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.id;

import java.util.UUID;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.ApiUsageStateId;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.BlobEntityId;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.GroupPermissionId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.NotificationId;
import org.thingsboard.server.common.data.id.NotificationRequestId;
import org.thingsboard.server.common.data.id.NotificationRuleId;
import org.thingsboard.server.common.data.id.NotificationTargetId;
import org.thingsboard.server.common.data.id.NotificationTemplateId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.QueueId;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.RpcId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;

public class EntityIdFactory {
    public static EntityId getByTypeAndUuid(int type, String uuid) {
        return EntityIdFactory.getByTypeAndUuid(EntityType.values()[type], UUID.fromString(uuid));
    }

    public static EntityId getByTypeAndUuid(String type, String uuid) {
        return EntityIdFactory.getByTypeAndUuid(EntityType.valueOf(type), UUID.fromString(uuid));
    }

    public static EntityId getByTypeAndId(String type, String uuid) {
        return EntityIdFactory.getByTypeAndUuid(EntityType.valueOf(type), UUID.fromString(uuid));
    }

    public static EntityId getByTypeAndId(EntityType type, String uuid) {
        return EntityIdFactory.getByTypeAndUuid(type, UUID.fromString(uuid));
    }

    public static EntityId getByTypeAndUuid(String type, UUID uuid) {
        return EntityIdFactory.getByTypeAndUuid(EntityType.valueOf(type), uuid);
    }

    public static EntityId getByTypeAndUuid(EntityType type, String uuid) {
        return EntityIdFactory.getByTypeAndUuid(type, UUID.fromString(uuid));
    }

    public static EntityId getByTypeAndUuid(EntityType type, UUID uuid) {
        switch (type) {
            case TENANT: {
                return TenantId.fromUUID(uuid);
            }
            case CUSTOMER: {
                return new CustomerId(uuid);
            }
            case USER: {
                return new UserId(uuid);
            }
            case DASHBOARD: {
                return new DashboardId(uuid);
            }
            case DEVICE: {
                return new DeviceId(uuid);
            }
            case ASSET: {
                return new AssetId(uuid);
            }
            case CONVERTER: {
                return new ConverterId(uuid);
            }
            case INTEGRATION: {
                return new IntegrationId(uuid);
            }
            case ALARM: {
                return new AlarmId(uuid);
            }
            case ENTITY_GROUP: {
                return new EntityGroupId(uuid);
            }
            case RULE_CHAIN: {
                return new RuleChainId(uuid);
            }
            case RULE_NODE: {
                return new RuleNodeId(uuid);
            }
            case SCHEDULER_EVENT: {
                return new SchedulerEventId(uuid);
            }
            case BLOB_ENTITY: {
                return new BlobEntityId(uuid);
            }
            case ENTITY_VIEW: {
                return new EntityViewId(uuid);
            }
            case ROLE: {
                return new RoleId(uuid);
            }
            case GROUP_PERMISSION: {
                return new GroupPermissionId(uuid);
            }
            case WIDGETS_BUNDLE: {
                return new WidgetsBundleId(uuid);
            }
            case WIDGET_TYPE: {
                return new WidgetTypeId(uuid);
            }
            case DEVICE_PROFILE: {
                return new DeviceProfileId(uuid);
            }
            case ASSET_PROFILE: {
                return new AssetProfileId(uuid);
            }
            case TENANT_PROFILE: {
                return new TenantProfileId(uuid);
            }
            case API_USAGE_STATE: {
                return new ApiUsageStateId(uuid);
            }
            case TB_RESOURCE: {
                return new TbResourceId(uuid);
            }
            case OTA_PACKAGE: {
                return new OtaPackageId(uuid);
            }
            case EDGE: {
                return new EdgeId(uuid);
            }
            case RPC: {
                return new RpcId(uuid);
            }
            case QUEUE: {
                return new QueueId(uuid);
            }
            case NOTIFICATION_TARGET: {
                return new NotificationTargetId(uuid);
            }
            case NOTIFICATION_REQUEST: {
                return new NotificationRequestId(uuid);
            }
            case NOTIFICATION_RULE: {
                return new NotificationRuleId(uuid);
            }
            case NOTIFICATION_TEMPLATE: {
                return new NotificationTemplateId(uuid);
            }
            case NOTIFICATION: {
                return new NotificationId(uuid);
            }
        }
        throw new IllegalArgumentException("EntityType " + type + " is not supported!");
    }

    public static EntityId getByEdgeEventTypeAndUuid(EdgeEventType edgeEventType, UUID uuid) {
        switch (edgeEventType) {
            case TENANT: {
                return new TenantId(uuid);
            }
            case CUSTOMER: {
                return new CustomerId(uuid);
            }
            case USER: {
                return new UserId(uuid);
            }
            case DASHBOARD: {
                return new DashboardId(uuid);
            }
            case DEVICE: {
                return new DeviceId(uuid);
            }
            case ASSET: {
                return new AssetId(uuid);
            }
            case ALARM: {
                return new AlarmId(uuid);
            }
            case RULE_CHAIN: {
                return new RuleChainId(uuid);
            }
            case ENTITY_VIEW: {
                return new EntityViewId(uuid);
            }
            case WIDGETS_BUNDLE: {
                return new WidgetsBundleId(uuid);
            }
            case WIDGET_TYPE: {
                return new WidgetTypeId(uuid);
            }
            case DEVICE_PROFILE: {
                return new DeviceProfileId(uuid);
            }
            case ASSET_PROFILE: {
                return new AssetProfileId(uuid);
            }
            case TENANT_PROFILE: {
                return new TenantProfileId(uuid);
            }
            case OTA_PACKAGE: {
                return new OtaPackageId(uuid);
            }
            case EDGE: {
                return new EdgeId(uuid);
            }
            case SCHEDULER_EVENT: {
                return new SchedulerEventId(uuid);
            }
            case ENTITY_GROUP: {
                return new EntityGroupId(uuid);
            }
            case ROLE: {
                return new RoleId(uuid);
            }
            case GROUP_PERMISSION: {
                return new GroupPermissionId(uuid);
            }
            case INTEGRATION: {
                return new IntegrationId(uuid);
            }
            case CONVERTER: {
                return new ConverterId(uuid);
            }
            case QUEUE: {
                return new QueueId(uuid);
            }
        }
        throw new IllegalArgumentException("EdgeEventType " + edgeEventType + " is not supported!");
    }
}

